package com.iesms.openservices.photovoltaic.response;

import com.iesms.openservices.cebase.entity.INode;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

/**
 * 电网树
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/13
 */
@Data
@Accessors(chain = true)
public class GridPowerTreeResponse implements INode<GridPowerTreeResponse, String> {

    private static final long serialVersionUID = -6774211549738638825L;

    /**
     * id
     */
    private String id;

    /**
     * 资源分类编号
     */
    private String sortNo;

    /**
     * 资源编号
     */
    private String no;

    /**
     * 资源名称
     */
    private String name;

    /**
     * 资源描述
     */
    private String desc;

    /**
     * 电压等级
     */
    private String voltageClass;

    /**
     * 资源级别
     */
    private Integer level;

    /**
     * 父节点id
     */
    private String parentId;

    /**
     * 是否有子孙节点
     */
    private boolean hasChildren;

    /**
     * 上级资源名称
     */
    private String parentName;

    /**
     * 上级资源描述
     */
    private String parentDesc;

    /**
     * 上级分类编号
     */
    private String parentSortNo;

    /**
     * 上级资源编号
     */
    private String parentNo;

    /**
     * 子孙节点
     */
    private List<GridPowerTreeResponse> children;

    @Override
    public List<GridPowerTreeResponse> getChildren() {
        if(this.children == null) {
            this.hasChildren = true;
            this.children = new ArrayList<>();
        }
        return this.children;
    }
}
