package com.iesms.openservices.photovoltaic.response;

import com.iesms.openservices.photovoltaic.enums.GridResSortNoEnum;
import com.iesms.openservices.photovoltaic.enums.GridResStatusEnum;
import com.iesms.openservices.photovoltaic.jsonobject.GridResourceGeoLocationAttrJsonObject;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 电网对象信息
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/13
 */
@Data
public class GridResourceResponse implements Serializable {

    private static final long serialVersionUID = -4431265675485367849L;

    /**
     * id
     */
    private Long id;

    /**
     * 父级标识
     */
    private Long parentId;

    /**
     * 电网资源分类编号
     * @see GridResSortNoEnum
     */
    private String gridResSortNo;

    /**
     * 电网资源编号
     */
    private String gridResNo;

    /**
     * 电网资源名称
     */
    private String gridResName;

    /**
     * 电网资源说明
     */
    private String gridResDesc;

    /**
     * 电网资源地址
     */
    private String gridResAddr;

    /**
     * 电网资源状态
     * @see GridResStatusEnum
     */
    private Integer gridResStatus;

    /**
     * 电压等级值
     */
    private String voltageClass;

    /**
     * 电压等级名称
     */
    private String voltageClassName;

    /**
     * 区域编码
     */
    private String adcode;

    /**
     * 投运人
     */
    private String gotorunner;

    /**
     * 投运日期
     */
    private Date gotorunDate;

    /**
     * 投运日期
     */
    private String gotorunDateStr;

    /**
     * 投运备注
     */
    private String gotorunRemark;

    /**
     * 联系人/责任人
     */
    private String contacter;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 设计容量
     */
    private BigDecimal networkDesignCapacity;

    /**
     * 变电站的限额（装机容量）
     */
    private BigDecimal substationRatedCapacity;

    /**
     * 线路和台区的限额
     */
    private BigDecimal powerlineLimitLoad;

    /**
     * 线路
     * 线径规格
     */
    private String powerlineWireDiameterSpec;

    /**
     * 线路
     * 材质
     */
    private String powerlineWireMaterial;

    /**
     * 设计间隔数
     */
    private Integer substationDesignIntervalCount;

    /**
     * 当前空余间隔数（单位：个）
     */
    private Integer substationSpareIntervalCount;

    /**
     * 当前空余间隔容量（单位：kVA）
     */
    private BigDecimal substationSpareIntervalCapacity;

    /**
     * 计划扩容（单位：kVA）
     */
    private BigDecimal networkPlanCapacity;

    /**
     * 地理位置信息
     */
    private GridResourceGeoLocationAttrJsonObject geoLocationAttr;
}
