package com.iesms.openservices.photovoltaic.response;

import lombok.Data;

import java.io.Serializable;

/**
 * @author liumu
 * @date 2022-01-20 14:32
 * 储能运行调度方案 - 返回参数
 */
@Data
public class MgosSeOsSchemeResponse implements Serializable {

    private static final long serialVersionUID = 4682686943001413337L;

    private Long id;

    /**
     * 用能客户名称
     */
    private String ceCustName;

    /**
     * 储能电站名称
     */
    private String ceStationName;

    /**
     * 方案名称
     */
    private String seOsSchemeName;

    /**
     * 计划开始日期
     */
    private String plannedStartDate;

    /**
     * 计划结束日期
     */
    private String plannedEndDate;

    /**
     * 实际开始时间
     */
    private String actualStartTime;

    /**
     * 实际结束时间
     */
    private String actualEndTime;

    /**
     * 方案状态：1 - 初始（待投放）；2 - 已投放（待启用）；3 - 已启用；4 - 已完成（计划结束完成）；5 - 提前结束（提前结束完成）；
     */
    private Integer seOsSchemeStatus;
}
