package com.iesms.openservices.photovoltaic.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author Lin yicheng
 * @date 2022/1/20 18:49
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class OperationalRevenueAnalysisResponse {

    /**
     * 日期
     */
    private String date;

    /**
     * 充电功率
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeAvgPower;

    /**
     * 充电时长
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeDuration;

    /**
     * 放电功率
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal dischargeAvgPower;

    /**
     * 放电时长
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal dischargeDuration;

    /**
     * 运行收益
     */
    private BigDecimal income;

    /**
     * 峰谷价差收益
     */
    private BigDecimal peakValleySpreadIncome;

}
