package com.iesms.openservices.photovoltaic.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 电站发电效率分析
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/20
 */
@Data
public class PowerStationEfficiencyAnalysisMultiResponse implements Serializable {

    private static final long serialVersionUID = -4724240307028806718L;

    /**
     * 标识
     */
    private Long id;

    /**
     * 用户编号
     */
    private String ceResNo;

    /**
     * 新能源投资商
     */
    private String investorName;

    /**
     * 发电户名
     */
    private String electricityName;

    /**
     * 用电户名
     */
    private String ceCustName;

    /**
     * 发电户号
     */
    private String electricityNo;

    /**
     * 行政区域
     */
    private String adname;

    /**
     * 投运年限名称
     */
    private String parallelDateName;

    /**
     * 排名
     */
    private Integer ranking;

    /**
     * 上月发电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal upEgenValueMonth;

    /**
     * 当年发电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal egenValueYear;

    /**
     * 上月利用小时数
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal upEqHoursMonth;

    /**
     * 年利用小时数
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal eqHoursYear;
}
