package com.iesms.openservices.photovoltaic.response;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/3/27
 */
@Data
public class PvCustDeviceInfoResponse implements Serializable {

    private static final long serialVersionUID = -6166586889628312893L;

    /**
     * 生产厂家
     */
    private String mdrCode;

    /**
     * 逆变器型号
     */
    private String modelCode;

    /**
     * 逆变器接入容量
     */
    private BigDecimal outPutPower;

    /**
     * 逆变器类型
     */
    private String inverterTypeName;

    /**
     * 组件规格
     */
    private String moduleType;

    /**
     * 组件数量
     */
    private Integer moduleCount;

    /**
     * 组件面积
     */
    private BigDecimal moduleArea;
}
