package com.iesms.openservices.photovoltaic.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/3/27
 */
@Data
public class PvCustInfoResponse implements Serializable {

    private static final long serialVersionUID = -4983280226792387493L;

    /**
     * 用户名称
     */
    private String ceCustName;

    /**
     * 用户id
     */
    private Long custId;

    /**
     * 装机容量
     */
    private BigDecimal installCapacity;

    /**
     * 并网电压等级
     */
    private String pvVoltageClassName;

    /**
     * 电站类型
     */
    private String pvTypeName;

    /**
     * 联系人
     */
    private String contacter;

    /**
     * 用户地址
     */
    private String ceCustAddr;

    /**
     * 投运日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date parallelDate;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 并网对象
     */
    private String gridResName;

    /**
     * 建筑类型名称
     */
    private String buildingTypeName;

    /**
     * 经度
     */
    private BigDecimal longitude;

    /**
     * 维度
     */
    private BigDecimal latitude;

    /**
     * 投资模式
     */
    private String inveModel;

    /**
     * 发电户号
     */
    private String electricityNo;

    /**
     * 用电户号
     */
    private String ceResNo;

    /**
     * 投资商联系人
     */
    private String investorContacter;

    /**
     * 投资商联系人手机号码
     */
    private String investorMobile;

    /**
     * 附件
     */
    private List<Map<String, Object>> attr;

    /**
     * 逆变器基本概况
     */
    private PvCustInverterInfoResponse inverterInfoResponse;

    /**
     * 组件基本概况
     */
    private PvCustModuleInfoResponse moduleInfoResponse;

    /**
     * 电站状态 1正常 2异常 3停机 4离线
     */
    private Integer status;

    /**
     * 异常条数
     */
    private Integer exCount;
}
