package com.iesms.openservices.photovoltaic.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Lin yicheng
 * @date 2022/4/27 14:45
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@SuperBuilder
public class PvStationAlarmResponse implements Serializable {

    private static final long serialVersionUID = 3774941536162677306L;

    /**
     * 新增告警数
     */
    private Long newlyIncreasedNum;

    /**
     * 已复归告警数
     */
    private Long revertedNum;

    /**
     * 未复归告警数
     */
    private Long notRevertedNum;

    /**
     * 告警复归平均时长
     */
    private BigDecimal avgRevertHours;

}
