package com.iesms.openservices.photovoltaic.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Lin yicheng
 * @date 2022/4/27 17:39
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@SuperBuilder
public class PvStationOpsResponse implements Serializable {

    private static final long serialVersionUID = -9079423549757919609L;

    /**
     * 新增运维工单数
     */
    private Long newlyIncreasedNum;

    /**
     * 已归档工单数
     */
    private Long archivedNum;

    /**
     * 在途工单数
     */
    private Long onTheWayNum;

    /**
     * 处理及时率
     */
    private BigDecimal timelyProcessingRate;

}
