package com.iesms.openservices.photovoltaic.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;

/**
 * @author Lin yicheng
 * @date 2022/4/19 15:25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@SuperBuilder
public class PvStationReportFormResponse {

    /**
     * 电站名称
     */
    private String pvStatName;

    /**
     * 公司名称
     */
    private String orgName;

    /**
     * 起始时间
     */
    private String startDate;

    /**
     * 持续天数
     */
    private Long durationDays;

    /**
     * 装机容量
     */
    private BigDecimal totalCapacity;

}
