package com.iesms.openservices.photovoltaic.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/11/30
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class RealtimeWorkingConditionResponse implements Serializable {

    private static final long serialVersionUID = 6363553795401522880L;

    /**
     * 储能电站装机容量
     */
    private BigDecimal powerInstalledCapacity;

    /**
     * 储能电站额定功率
     */
    private BigDecimal powerRatedPower;

    /**
     * 储能电站变流器设备数
     */
    private Integer powerInverterDeviceCount;

    /**
     * 储能电站电池组数量
     */
    private Integer powerBatteryPackCount;

    /**
     * 储能电站当前运行状态
     */
    private String powerOperationName;

    /**
     * 储能电站实时功率
     */
    private BigDecimal powerRealtimePower;

    /**
     * 储能电站总soc
     */
    private BigDecimal powerSoc;

    /**
     * 储能电站累计充电量
     */
    private BigDecimal powerElectricTotal;

    /**
     * 储能电站累计放电量
     */
    private BigDecimal powerPullElectricTotal;

    /**
     * 变流器电池容量
     */
    private BigDecimal inverterBatteryCapacity;

    /**
     * 变流器额定功率
     */
    private BigDecimal inverterRatedPower;

    /**
     * 变流器电池组数量
     */
    private BigDecimal inverterBatteryPackCount;

    /**
     * 变流器最大允许放电功率
     */
    private BigDecimal inverterMaxDischargePower;

    /**
     * 变流器最大允许充电功率
     */
    private BigDecimal inverterMaxChargingPower;

    /**
     * 变流器当前运行状态
     */
    private String inverterOperationStatusName;

    /**
     * 变流器实时功率
     */
    private BigDecimal inverterRealtimePower;

    /**
     * 变流器总soc
     */
    private BigDecimal inverterSoc;

    /**
     * 变流器变流器温度
     */
    private BigDecimal inverterTemperature;

    /**
     * 变流器电网频率
     */
    private BigDecimal inverterLineFrequency;

    /**
     * 变流器累计充电量
     */
    private BigDecimal inverterElectricTotal;

    /**
     * 变流器累计放电量
     */
    private BigDecimal inverterPullElectricTotal;

    /**
     * 变流器直流电流
     */
    private BigDecimal cocurrentElectricity;

    /**
     * 变流器直流电压
     */
    private BigDecimal cocurrentVoltage;

    /**
     * 变流器交流侧A项电流
     */
    private BigDecimal exchangeElectricityA;

    /**
     * 变流器交流侧B项电流
     */
    private BigDecimal exchangeElectricityB;

    /**
     * 变流器交流侧C项电流
     */
    private BigDecimal exchangeElectricityC;

    /**
     * 变流器交流侧AB项电压
     */
    private BigDecimal exchangeElectricityAB;

    /**
     * 变流器交流侧BC项电压
     */
    private BigDecimal exchangeElectricityBC;

    /**
     * 变流器交流侧AC项电压
     */
    private BigDecimal exchangeElectricityAC;

    /**
     * BMS电池容量
     */
    private BigDecimal bmsBatteryCapacity;

    /**
     * BMS最大允许充电电流
     */
    private BigDecimal maxChargeElectric;

    /**
     * BMS最大允许放电电流
     */
    private BigDecimal maxPutElectric;

    /**
     * BMS电池状态
     */
    private BigDecimal batteryStatus;

    /**
     * BMS电池电压
     */
    private BigDecimal batteryVoltage;

    /**
     * BMS电池电流
     */
    private BigDecimal batteryElectric;

    /**
     * BMS soc
     */
    private BigDecimal soc;

    /**
     * BMS soh
     */
    private BigDecimal soh;

    /**
     * BMS电池温度
     */
    private BigDecimal batteryTemperature;

    /**
     * BMS实时功率
     */
    private BigDecimal batteryRealtimePower;

    /**
     * BMS累计充电量
     */
    private BigDecimal batteryElectricTotal;

    /**
     * BMS累计放电量
     */
    private BigDecimal batteryPullElectricTotal;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 变流器名称
     */
    private String pcsName;

    /**
     * 电池名称
     */
    private String bmsName;

}
