package com.iesms.openservices.photovoltaic.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author Lin yicheng
 * @date 2022/1/18 13:35
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class SchemeTrackResponse {

    /**
     * 方案Id
     */
    private Long schemeId;

    /**
     * 方案名称
     */
    private String seOsSchemeName;

    /**
     *  方案状态
     */
    private Long seOsSchemeStatus;

    /**
     * 计划起始日期
     */
    private String plannedStartDate;

    /**
     * 计划结束日期
     */
    private String plannedEndDate;

    /**
     * 计划起始时间
     */
    private String plannedStartTime;

    /**
     * 计划结束时间
     */
    private String plannedEndTime;

    /**
     * 实际开始日期
     */
    private String actualStartDate;

    /**
     * 实际结束日期
     */
    private String actualEndDate;

    /**
     * 实际开始时间
     */
    private String actualStartTime;

    /**
     * 实际结束时间
     */
    private String actualEndTime;

    /**
     * 量测点Id
     */
    private Long measPointId;

    /**
     * 充放电量明细
     */
    private String powerDetails;

}
