package com.iesms.openservices.photovoltaic.response;

import lombok.Data;

import java.io.Serializable;

/**
 * @author liumu
 * @date 2021-11-30 10:31
 * 忠县储能 - 补贴核算数据 - 响应参数
 */
@Data
public class ZxSubsidyStatisticDataResponse implements Serializable {

    private static final long serialVersionUID = 9044851941438112236L;

    /**
     * 用能资源id
     */
    private Long resourceId;

    /**
     * 电站用户编号（用能资源编号）
     */
    private String resourceNo;

    /**
     * 电站用户名称（用能资源名称）
     */
    private String resourceName;

    /**
     * 日期
     */
    private String dateStr;

    /**
     * 放电量（kWh）
     */
    private String discharge;

    /**
     * 补贴收益（元）
     */
    private String subsidyProfit;
}
