package com.iesms.openservices.photovoltaic.service;

import cn.hutool.core.lang.Dict;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.iesms.openservices.photovoltaic.entity.*;
import com.iesms.openservices.photovoltaic.request.AGQueryHistoryQueryRequest;
import com.iesms.openservices.photovoltaic.request.AgHomePageRequest;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface AgHomePageService {

    /**
     * 获取降碳智慧绿网设备概况
     */
    int getCarbonReductionDevInfo(AgHomePageRequest request);

    /**
     * 获取降碳提效日统计表信息（按用能客户）
     */
    AgStatCecustCreDayDto getAgStatCecustCreDay(AgHomePageRequest request);

    /**
     * 获取降碳提效日月年统计表信息（按用能客户）
     */
    Map<String, Object> getAgStatCecustCreCure(AgHomePageRequest request);

    /**
     * 获取降碳提效日统计表信息（按用能容器）
     */
    AgStatCecntrCreDayDto getAgStatCecntrCreDay(AgHomePageRequest request);

    /**
     * 获取降碳提效日月年统计表信息（按用能容器）
     */
    Map<String, Object> getAgStatCecntrCreCure(AgHomePageRequest request);

    /**
     * 获取容器（楼层）中的室外 室内 人体探测终端数
     */
    int getCeCntrDevCount(AgHomePageRequest request);

    /**
     * 根据用能资源编号查询用能资源（容器）id
     */
    AgHomePageDto getCeResIdByCeResNo(AgHomePageRequest request);

    /**
     * 获取温度、光照曲线
     */
    Map<String, Object> getAgStatCecntrTempluxDayCure(AgHomePageRequest request);

    /**
     * 获取区域历史策略执行情况
     */
    List<AgEffectEventDto> getEffectEventInfo(AgHomePageRequest request);

    /**
     * 获取设备信息
     */
    AgdeviceInfoDto getAgdeviceInfo(AgHomePageRequest request);

    /**
     * 获取曲线当天策略点
     */
    List<AgEffectEventDto> getEventContentList(AgHomePageRequest request);

    /**
     * 根据楼层id获取该楼层下的房间信息
     */
    List<AgHomePageDto> getAgRoomInfoByCeResId(AgHomePageRequest request);

    /**
     * @description: ；绿色运行模块
     * @author: DuanYingJie
     * @date: 2022/6/20 17:27
     * @param: [map]
     * @return: 数据Map集合
     **/
    Map<String,Object> MapGreenRun(AgHomePageRequest request);

    /**
     * 获取容器数据
     *
     * @param dict
     * @return
     */
    Map<String, Object> getCecntrData(Dict dict);

    IPage<Dict> queryHistory(AGQueryHistoryQueryRequest request);

    List<Dict> queryDevice(String type);

    void updateDevice(Long id, String ceDevProps);

    List<Map<String, Object>> selectList(String request);

    void updateSql(String request);

    void deleteSql(String request);

    Dict getByNo(String id, String devNo);
}
