package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.request.CarbonAssetAdcodeRequest;
import com.iesms.openservices.photovoltaic.request.CarbonAssetCustRequest;
import com.iesms.openservices.photovoltaic.request.CarbonAssetStationRequest;
import com.iesms.openservices.photovoltaic.request.CarbonAssetCurveRequest;
import com.iesms.openservices.photovoltaic.response.*;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/14
 */
public interface CarbonAssetService {

    /**
     * 电站碳资产列表
     *
     * @param param
     * @return
     */
    List<CarbonAssetStationResponse> listStation(CarbonAssetStationRequest param);

    /**
     * 电站碳资产列表总数
     *
     * @param param
     * @return
     */
    Long listStationTotal(CarbonAssetStationRequest param);

    /**
     * 行政区域碳资产列表
     *
     * @param param
     * @return
     */
    List<CarbonAssetAdcodeResponse> listAdcode(CarbonAssetAdcodeRequest param);

    /**
     * 行政区域碳资产
     *
     * @param orgNo
     * @param adcode
     * @return
     */
    CarbonAssetAdcodeResponse getAdcode(String orgNo, String adcode);

    /**
     * 重点控排企业碳减排分析列表
     *
     * @param param
     * @return
     */
    List<CarbonAssetCustResponse> listCust(CarbonAssetCustRequest param);

    /**
     * 重点控排企业碳减排分析列表总数
     *
     * @param param
     * @return
     */
    Long listCustTotal(CarbonAssetCustRequest param);

    /**
     * 碳配额分析列表
     *
     * @param custId
     * @return
     */
    List<CarbonAnalysisMultiResponse> listAnalysis(Long custId);

    /**
     * 发电户名（下拉框列表）
     *
     * @param orgNo
     * @param emphasis
     * @param pvInvestorId
     * @param adCode
     * @return
     */
    List<PowerStationElectricityNameResponse> listElectricityName(String orgNo, Integer emphasis, Long pvInvestorId, String adCode);

    /**
     * 获取电站月曲线数据
     *
     * @param id
     * @return
     */
    List<CurveMonthDataResponse> getPowerStationCurveMonthData(Long id, Integer date);

    /**
     * 获取行政区域月曲线数据
     *
     * @param orgNo
     * @param adCode
     * @return
     */
    List<CurveMonthDataResponse> getAdCodeCurveMonthData(String orgNo, String adCode);

    /**
     * 行政区域（下拉框）
     *
     * @return
     */
    List<AdCodeNameResponse> listAdCodeName();

    /**
     * 获取电站的碳配额指标
     *
     * @param id
     * @return
     */
    BigDecimal getCustEmissionQuota(Long id);

    List<CurveDayDataResponse> getCustCurveDay(@Param("ceCustId") Long ceCustId);

    Map<String, Object> getCustEncons(Long custId);
}
