package com.iesms.openservices.photovoltaic.service;

import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.iesms.openservices.photovoltaic.entity.DayouWorkOrder;
import com.iesms.openservices.photovoltaic.request.WorkOrderListRequest;
import com.iesms.openservices.photovoltaic.response.WorkOrderListVo;

import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/5/25
 */
public interface DayouWordOrderService extends IService<DayouWorkOrder> {

    /**
     * 查询工单列表
     *
     * @param workOrderListRequest
     * @return WorkOrderListVo
     * @author: JIE
     * @date: 2023/5/26 9:41
     */
    WorkOrderListVo queryListWorkOrder(WorkOrderListRequest workOrderListRequest);


    /**
     * 根据工单id查询工单详情
     *
     * @param id 工单id
     * @return 工单详情
     * @author: JIE
     * @date: 2023/5/26 14:50
     */
    DayouWorkOrder getWorkOrderDetailsById(String id);

    /**
     * 工单统计
     *
     * @param date
     * @param dateType
     * @param workType
     * @return
     */
    List<JSONObject> workOrderStatistic(String orgNo, String date, Integer dateType, Integer workType, String adName);

}
