package com.iesms.openservices.photovoltaic.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.easesource.data.bean.Pager;
import com.iesms.openservices.photovoltaic.request.ElectricQuantityReportFormsRequest;
import com.iesms.openservices.photovoltaic.response.StationVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/10/27
 */
public interface ElectricQuantityReportFormsService {

    /**
     * 获取单位列表
     *
     * @param orgNo
     * @return
     */
    List<Map<String, Object>> listOrg(String orgNo);

    /**
     * 电站列表
     *
     * @param orgNo
     * @return
     */
    List<StationVo> listStation(String orgNo);

    /**
     * 报表
     *
     * @param page
     * @param request
     * @return
     */
    IPage<Map<String, Object>> list(Page<Map<String, Object>> page, ElectricQuantityReportFormsRequest request);

    /**
     * 报表列表
     *
     * @param request
     * @return
     */
    Map<String, Object> list(Pager pager, ElectricQuantityReportFormsRequest request);

    /**
     * 报表累计电量
     *
     * @param request
     * @return
     */
    BigDecimal sum(ElectricQuantityReportFormsRequest request);
}
