package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.common.BaseCrudService;
import com.iesms.openservices.photovoltaic.entity.GridResource;
import com.iesms.openservices.photovoltaic.response.GridPowerTreeResponse;
import com.iesms.openservices.photovoltaic.response.PowerStationElectricityNameResponse;
import com.iesms.openservices.photovoltaic.response.GridResourceNodeNameMultiResponse;
import com.iesms.openservices.photovoltaic.response.GridResourceResponse;

import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/12
 */
public interface GirdResourceService extends BaseCrudService<GridResource> {

    /**
     * 查询电网树列表
     *
     * @param orgNo
     * @return
     */
    List<GridPowerTreeResponse> listRelaResource(String orgNo);

    /**
     * 查询编号是否唯一
     *
     * @param orgNo
     * @param gridResNo
     * @return
     */
    GridResource selectByResNo(String orgNo, String gridResNo);

    /**
     * 电网对象信息
     *
     * @param id
     * @return
     */
    GridResourceResponse getInfoById(Long id);

    /**
     * 电网树节点名称（模糊搜索）
     *
     * @param orgNo
     * @param name
     * @return
     */
    List<GridResourceNodeNameMultiResponse> listResourceNodeName(String orgNo, String name);
}
