package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.request.GqHomePageRequest;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author DuanYingJie
 * @className GqHomePageService
 * @data 2022/8/21 16:27
 * @Description 古泉大屏接口
 **/
public interface GqHomePageService {

    /**
     * @description: 光伏运行监控
     * @author: DuanYingJie
     * @date: 2022/8/21 16:28
     * @return: 光伏运行监控数据
     **/
    Map<String, BigDecimal> photovoltaicOperationMonitoring(GqHomePageRequest gqHomePageRequest);

    /**
     * @description: 风机运行监控
     * @author: DuanYingJie
     * @date: 2022/8/22 9:48
     * @param: [gqHomePageRequest]
     * @return: 风机运行监控数据
     **/
    Map<String, BigDecimal> fanOperationMonitoring(GqHomePageRequest gqHomePageRequest);

    /**
     * @description: 绿色出行服务
     * @author: DuanYingJie
     * @date: 2022/8/22 11:14
     * @param: [gqHomePageRequest]
     * @return: 绿色出行服务数据
     **/
    Map<String, BigDecimal> greenTravelService(GqHomePageRequest gqHomePageRequest);

    /**
     * @description: 办公室用电负荷运行监控 （5G 数据机房）
     * @author: DuanYingJie
     * @date: 2022/8/22 13:52
     * @param: [gqHomePageRequest]
     * @return: 办公室用电负荷运行监控数据
     **/
    Map<String, Object> officeElectricity(GqHomePageRequest gqHomePageRequest);

    /**
     * @description: 清洁能源消纳率、直流负载节约电量、柔性负荷可调能力、碳平衡指标数
     * @author: DuanYingJie
     * @date: 2022/8/22 14:59
     * @param: [gqHomePageRequest]
     * @return: 清洁能源消纳率、直流负载节约电量、柔性负荷可调能力、碳平衡指标数
     **/
    Map<String, BigDecimal> calculate(GqHomePageRequest gqHomePageRequest);

    /**
     * @description: 获取空调当日最大负荷
     * @author: DuanYingJie
     * @date: 2022/8/23 11:09
     * @param: [gqHomePageRequest]
     * @return: 空调当日最大负荷
     **/
    BigDecimal getceStatCedeviceEloadDaySUMmaxValue(GqHomePageRequest gqHomePageRequest);

    /**
     * @description: 获取获取空调交直流用电
     * @author: DuanYingJie
     * @date: 2022/8/23 11:34
     * @param: [gqHomePageRequest]
     * @return: 空调交直流用电
     **/
    Map<String, BigDecimal> getProportion(GqHomePageRequest gqHomePageRequest);

    /**
     * @description: 获取光伏日用电曲线
     * @author: DuanYingJie
     * @date: 2022/9/7 15:51
     * @param: [gqHomePageRequest]
     * @return: 光伏今日用电曲线
     **/
    Map<String, Object> getPvStatOrgDay(GqHomePageRequest gqHomePageRequest);

    /**
     * @description: 获取光伏月用电曲线
     * @author: DuanYingJie
     * @date: 2022/9/7 15:57
     * @param: [gqHomePageRequest]
     * @return: 光伏月用电曲线
     **/
    Map<String, Object> listPvStatOrgDay(GqHomePageRequest gqHomePageRequest);

    /**
     * @description: 获取光伏年用电曲线
     * @author: DuanYingJie
     * @date: 2022/9/7 16:03
     * @param: [gqHomePageRequest]
     * @return: 光伏年用电曲线
     **/
    Map<String, Object> listPvStatOrgMonth(GqHomePageRequest gqHomePageRequest);

    /**
     * 储能月、年充放电量曲线
     */
    Map<String, Object> getEnergyStoragePowerCurve(GqHomePageRequest gqHomePageRequest);

    /**
     * 获取V2G日月年充电量曲线
     */
    Map<String, Object> getV2GEconsCurve(GqHomePageRequest request);

    /**
     * @description: 获取设备量测点
     * @param: orgNo 单位编号
     * ceResSortNoList 设备类型
     * @return: 量测点集合
     * @author: JIE
     * @date: 2023/3/17 10:54
     */
    List<Long> selectMeasPointIds(String orgNo, List<String> ceResSortNoList);
}
