package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.common.BaseCrudService;
import com.iesms.openservices.photovoltaic.entity.GridRela;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/13
 */
public interface GridRelaService extends BaseCrudService<GridRela> {

    /**
     * 查询当前电网是否存在下级
     *
     * @param parentId
     * @return
     */
    Long countByParentId(Long parentId);

    /**
     * 查询当前电网对象的父级
     *
     * @param id
     * @return
     */
    GridRela getParentByResId(Long id);
}
