package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.request.PowerStationEfficiencyAnalysisMultiRequest;
import com.iesms.openservices.photovoltaic.response.AdCodeHealthEvaluateDetailDataGetResponse;
import com.iesms.openservices.photovoltaic.response.AdCodeHealthEvaluateGetResponse;
import com.iesms.openservices.photovoltaic.response.PowerStationEfficiencyAnalysisMultiResponse;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/20
 */
public interface HealthEvaluateService {

    /**
     * 电站发电效率分析列表
     *
     * @param param
     * @return
     */
    List<PowerStationEfficiencyAnalysisMultiResponse> listEfficiencyAnalysis(PowerStationEfficiencyAnalysisMultiRequest param);

    /**
     * 电站发电效率分析列表总数
     *
     * @param param
     * @return
     */
    Long listEfficiencyAnalysisTotal(PowerStationEfficiencyAnalysisMultiRequest param);

    /**
     * 获取区域光伏健康评价列表数据
     *
     * @param orgNo
     * @return
     */
    List<AdCodeHealthEvaluateGetResponse> listAdCodeHealthEvaluate(String orgNo, String adCode);

    /**
     * 获取区域光伏健康评价详细数据
     *
     * @param orgNo
     * @param adCode
     * @return
     */
    AdCodeHealthEvaluateDetailDataGetResponse getAdCodeHealthEvaluateDetailData(String orgNo, String adCode);

    /**
     * 查询整个温州市下上个月的平均利用小时数
     *
     * @param orgNo
     * @return
     */
    BigDecimal getAllAdCodeHourAvg(String orgNo);
}
