package com.iesms.openservices.photovoltaic.service;


import com.iesms.openservices.photovoltaic.entity.GeneratingCapacity;
import com.iesms.openservices.photovoltaic.entity.WpStatWpstationEloadDay;
import com.iesms.openservices.photovoltaic.request.AgHomePageRequest;
import com.iesms.openservices.photovoltaic.request.GmDevMeterRequest;
import com.iesms.openservices.photovoltaic.request.GqHomePageRequest;
import com.iesms.openservices.photovoltaic.response.CeResSortNoResponse;

import java.util.List;
import java.util.Map;

/**
 * 发电功率日统计（按风力电站）Service接口
 *
 * @author JIE
 * @date 2022-05-18
 */
public interface IWpStatWpstationEloadDayService {

    /**
     * 查询每小时的发电功率（根据用户能客户标识和当前日期）
     *
     * @author duanyingie
     * @data 2022/5/18
     */
    Map<String, Object> selectWpStatWpstationEloadDayByCeCustId(WpStatWpstationEloadDay wpStatWpstationEloadDay);

    /**
     * @Description 获取当日发电量和累计发电量 根据当前日期
     * @author duanyingie
     * @data 2022/5/18
     */
    GeneratingCapacity selectWpStatWpstationDayByDateStat(WpStatWpstationEloadDay wpStatWpstationEloadDay);

    /**
     * @Description 用电设备类型为5G数据机房、智慧路灯关联的监测的表计的实时功率
     * @author duanyingie
     * @data 2022/5/20
     */
    Map<String, Object> getwpStatControllerEloadDay(WpStatWpstationEloadDay wpStatWpstationEloadDay);

    /**
     * @Description 用电设备类型为电动自行车充电桩的实时功率
     * @author duanyingie
     * @data 2022/5/20
     */
    Map<String, Object> getDevEbikeDevice(WpStatWpstationEloadDay wpStatWpstationEloadDay);

    /**
     * @description: 微电网概况
     * @author: DuanYingJie
     * @date: 2022/7/12 14:56
     * @param: [wpStatWpstationEloadDay]
     * @return:
     **/
    Map<String, Object> getGeneratingCapacityInfo(WpStatWpstationEloadDay wpStatWpstationEloadDay);

    /**
     * @description: 获取量测点标识
     * @author: DuanYingJie
     * @date: 2022/7/20 10:10
     * @param: [orgNo]
     * @return: 量测点标识
     **/
    List<CeResSortNoResponse> listCeResSortNoResponse(GmDevMeterRequest gmDevMeterRequest);

    /**
     * @description: 获取减排二氧化碳
     * @author: DuanYingJie
     * @date: 2022/7/20 15:45
     * @param: [orgNo, dateStat]
     * @return: 减排二氧化碳
     **/
    Double getScdeValueAccum(String orgNo);


    /**
     * 获取日月年电量曲线数据
     */
    Map<String, Object> getBuildAndEbikeEconsCurve(AgHomePageRequest request);

    /**
     * 获取日月年功率曲线数据
     */
    Map<String, Object> getBuildAndEbikeEloadCurve(AgHomePageRequest request);

    /**
     * 获取楼宇CPS以及绿色出行的当日当月当年累计发电量
     */
    Map<String, Object> getBuildAndEbikeEconsInfo(AgHomePageRequest request);

    /**
     * 获取楼宇CPS以及绿色出行的负荷信息（日月年）
     */
    Map<String, Object> getBuildAndEbikeEloadDayInfo(AgHomePageRequest request);

    /**
     * @description: 光伏功率曲线
     * @author: DuanYingJie
     * @date: 2022/8/1 14:53
     * @param: [m]
     * @return: 光伏功率曲线
     **/
    Map<String, Object> getEloadLine(Map<String, String> m);

    /**
     * @description: 根据量测表计编号 / 量测通信地址 获取量测点标识
     * @author: DuanYingJie
     * @date: 2022/8/4 14:46
     * @param: [gmDevMeterRequest]
     * @return: 量测点标识
     **/
    String getmeasPointId(GmDevMeterRequest gmDevMeterRequest);

    /**
     * @description: 查询风机日发电曲线
     * @author: DuanYingJie
     * @date: 2022/7/20 15:34
     * @param: [orgNo, type]
     * @return: 风机当日发电曲线
     **/
    Map<String, Object> listWpStatOrgDay(GqHomePageRequest gqHomePageRequest);

    /**
     * @description: 获取风机月发电曲线
     * @author: DuanYingJie
     * @date: 2022/7/20 17:24
     * @param: [orgNo]
     * @return: 风机每月发电曲线
     **/
    Map<String, Object> listEgenValueDay(GqHomePageRequest request);

    /**
     * @description: 获取风机年发电曲线
     * @author: DuanYingJie
     * @date: 2022/7/20 15:42
     * @param: [orgNo, dateStat]
     * @return: 风机年发电曲线
     **/
    Map<String, Object> listWpStatOrgMonth(GqHomePageRequest request);

    /**
     * 根据设备编号，获取量测点id
     */
    List<String> getMeasPointIdByCeDevNo(AgHomePageRequest agHomePageRequest);


    /**
     * @description: 根据设备id查询光伏设备状态
     * @author: DuanYingJie
     * @date: 2022/10/12 10:42
     * @param: [pvDeviceId]
     * @return: 光伏设备状态
     **/
    String getpvDeviceOpsStatus(String pvDeviceId);
}
