package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.entity.MgosSeOsSchemeInfo;
import com.iesms.openservices.photovoltaic.request.MgosSeOsSchemeRequest;
import com.iesms.openservices.photovoltaic.response.MgosSeOsSchemeResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author liumu
 * @date 2022-01-19 13:58
 * 储能运行调度方案
 */
public interface MgosSeOsSchemeService {

    /**
     * 通过方案名称获取方案（方案名称唯一性校验）
     *
     * @param orgNo
     * @param schemeName
     * @param id
     * @return
     */
    Long queryMgosSeOsSchemeBySchemeName(String orgNo, String schemeName, Long id);

    /**
     * 通过储能电站id和日期（计划）区间获取方案（电站在指定区间内是否已有方案存在）
     *
     * @param ceStationId
     * @param left        实际开始时间
     * @param right       实际结束时间
     * @return
     */
    Long queryMgosSeOsSchemeByCeStationIdAndDateTimeScope(Long ceStationId, String left, String right);

    /**
     * 添加方案
     *
     * @param param
     */
    void addMgosSeOsScheme(MgosSeOsSchemeRequest param);

    /**
     * 获取指定id中方案状态为1（待投放）的方案个数
     *
     * @param ids
     * @return
     */
    Integer queryMgosSeOsSchemeStatus1Count(List<Long> ids);

    /**
     * 删除方案
     *
     * @param ids
     */
    void delMgosSeOsScheme(@Param("ids") List<Long> ids);

    /**
     * 获取方案列表
     *
     * @param param
     * @return
     */
    List<MgosSeOsSchemeResponse> queryMgosSeOsSchemeList(MgosSeOsSchemeRequest param);

    /**
     * 获取方案计数
     *
     * @param param
     * @return
     */
    Integer queryMgosSeOsSchemeCount(MgosSeOsSchemeRequest param);

    /**
     * 获取方案
     *
     * @param id
     * @return
     */
    MgosSeOsSchemeInfo queryMgosSeOsSchemeById(Long id);

    /**
     * 更新方案
     *
     * @param param
     */
    void updateMgosSeOsScheme(MgosSeOsSchemeRequest param);

}
