package com.iesms.openservices.photovoltaic.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.iesms.openservices.photovoltaic.common.BaseCrudService;
import com.iesms.openservices.photovoltaic.entity.MgosSeOsScheme;
import com.iesms.openservices.photovoltaic.request.MgosTmplSeOsSchemeRequest;
import com.iesms.openservices.photovoltaic.response.MgosTmplSeOsSchemeResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author liumu
 * @date 2022-01-18 13:34
 * 储能运行调度方案模板
 */
public interface MgosTmplSeOsSchemeService extends BaseCrudService<MgosSeOsScheme> {

    /**
     * 获取储能运行调度方案模板列表
     *
     * @param param
     * @return
     */
    List<MgosTmplSeOsSchemeResponse> queryMgosTmplSeOsSchemeList(MgosTmplSeOsSchemeRequest param);

    /**
     * 获取储能运行调度方案模板计数
     *
     * @param param
     * @return
     */
    int queryMgosTmplSeOsSchemeCount(MgosTmplSeOsSchemeRequest param);

    /**
     * 添加方案模板
     *
     * @param param
     */
    void addMgosTmplSeOsScheme(MgosTmplSeOsSchemeRequest param);

    /**
     * 通过模板名称获取模板（模板名称唯一性校验）
     * @param orgNo
     * @param tmplName
     * @param id
     * @return
     */
    Long queryMgosTmplSeOsSchemeByTmplName(String orgNo,String tmplName,Long id);

    /**
     * 更新方案模板
     *
     * @param param
     */
    void updateMgosTmplSeOsScheme(MgosTmplSeOsSchemeRequest param);

    /**
     * 删除方案模板
     *
     * @param ids
     */
    void delMgosTmplSeOsScheme(@Param("ids") List<Long> ids);
}
