package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.request.SopRecordRequest;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @description: 光伏接口
 * @author: DuanYingJie
 * @date: 2022/7/22 16:21
 **/
public interface NengDaService {
    
    /**
     * @description: 获取告警数据
     * @author: DuanYingJie 
     * @date: 2022/7/22 16:18
     * @param: []
     * @return: 告警数据
     **/
    Map<String,Object> getReportAnEmergency(SopRecordRequest sopRecordRequest);

    /**
     * 获取光伏台账信息
     *
     * @param orgNo
     * @return
     */
    List<Map<String, Object>> getStandingBook(String orgNo);

    /**
     * 获取逆变器状态
     *
     * @param electricityNo
     * @return
     */
    Map<String, Object> getInvertStatus(String electricityNo);

    /**
     * 获取光伏发电量
     *
     * @param electricityNo
     * @param date
     * @return
     */
    Map<String, BigDecimal> getEcons(String electricityNo, Date date);

    /**
     * 获取光伏发电功率
     *
     * @param electricityNo
     * @param date
     * @return
     */
    Map<String, BigDecimal> getEload(String electricityNo, Date date);

}
