package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.request.OperationalRevenueAnalysisRequest;
import com.iesms.openservices.photovoltaic.response.OperationalRevenueAnalysisResponse;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Lin yicheng
 * @date 2022/1/20 18:26
 */
public interface OperationalRevenueAnalysisService {

    /**
     * 获取储能运行收益日统计（按储能站）
     * @param request
     * @return list
     */
    List<OperationalRevenueAnalysisResponse> queryDayList(OperationalRevenueAnalysisRequest request);

    /**
     * 获取月峰谷价差收益
     * @param request
     * @return BigDecimal
     */
    BigDecimal queryMonthPeakValleySpreadIncome(OperationalRevenueAnalysisRequest request);

    /**
     * 获取储能运行收益月统计（按储能站）
     * @param request
     * @return list
     */
    List<OperationalRevenueAnalysisResponse> queryMonthList(OperationalRevenueAnalysisRequest request);

    /**
     * 获取年峰谷价差收益
     * @param request
     * @return BigDecimal
     */
    BigDecimal queryYearPeakValleySpreadIncome(OperationalRevenueAnalysisRequest request);

}
