package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.common.BaseCrudService;
import com.iesms.openservices.photovoltaic.entity.*;

import java.util.List;

public interface PhoTestWzImportUserService extends BaseCrudService<TestWzImportUser> {


    /**
     * 批量插入用能点表
     */
    int insertPhoCePoint(List<PhoCePoint> list);

    /**
     * 批量插入用户表
     */
    int insertPhoCeCust(List<PhoCeCust> list);

    /**
     * 批量插入用能资源表
     */
    int insertPhoCeResource(List<PhoCeResource> list);

    /**
     * 批量插入用能客户社区资源关系表
     */
    int insertPhoCeCustDistNeighborhoodRela(List<PhoCeCustDistNeighborhoodRela> list);

    /**
     * 根据模板id获取费率时段；电度 基本 力调电费
     */
    PkgMeteringBillingElec getPkgMeteringBillingElec(Long id);

    /**
     * 批量插入用能客户费率时段方案设置（用能点）
     */
    int insertMbCustRatePeriodScheme(List<MbCustRatePeriodScheme> list);

    /**
     * 批量插入用能客户计费方案设置（用能点）
     */
    int insertMbCustBillingScheme(List<MbCustBillingScheme> list);

    /**
     * 批量插入用能客户用电计量计费套餐方案设置（用能点）
     */
    int insertMbCustPkgBillingScheme(List<MbCustPkgBillingScheme> list);
}
