package com.iesms.openservices.photovoltaic.service;

import cn.hutool.json.JSONObject;
import com.iesms.openservices.photovoltaic.response.PvCustDeviceInfoResponse;
import com.iesms.openservices.photovoltaic.response.PvCustInfoResponse;

import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/3/27
 */
public interface PvCustService {

    /**
     * 查看实时监测用户详细信息
     *
     * @param custId
     * @return
     */
    PvCustInfoResponse getPvCustInfo(Long custId);

    /**
     * 获取客户下的逆变器或组件
     *
     * @param custId
     * @param sortNo
     * @return
     */
    List<PvCustDeviceInfoResponse> listCustDeviceInfoByCust(Long custId, String sortNo);

    List<Map<String, Object>> getDevice(Long custId);

    List<Map<String, Object>> getModule(Long custId);

    List<Map<String, Object>> getTerm(Long custId);

    List<Map<String, Object>> getData(Long custId, String no);

    /**
     * 电站健康状态
     *
     * @param orgNo
     * @param date
     * @return
     */
    JSONObject powerStationHealthStatus(String orgNo, String date);

    /**
     * 工单信息
     *
     * @param orgNo
     * @return
     */
    JSONObject workOrderInformation(String orgNo);

    /**
     * 电站发电量情况
     *
     * @param orgNo
     * @param dateType
     * @param date
     * @return
     */
    List<JSONObject> powerStationPerformance(String orgNo, Integer dateType, String date);

    /**
     * 大有新大屏地图
     *
     * @param orgNo
     * @return
     */
    List<JSONObject> getLargeScreenMap(String orgNo);

    /**
     * 建设历程
     *
     * @param orgNo
     * @return
     */
    List<JSONObject> getConstructionCourse(String orgNo, String adCode);

    JSONObject getCustElectricByCustId(Long ceCustId, String monthStat);
}
