package com.iesms.openservices.photovoltaic.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.iesms.openservices.photovoltaic.common.BaseCrudService;
import com.iesms.openservices.photovoltaic.entity.PvRelationStation;

import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/8/23
 */
public interface PvRelationStationService extends BaseCrudService<PvRelationStation> {

    /**
     * 查找业主关联电站列表
     *
     * @param userId
     * @return
     */
    IPage<Map<String, Object>> listStation(IPage<PvRelationStation> page, Long userId);

    /**
     * 获取电站信息
     *
     * @param userId
     * @return
     */
    Map<String, Object> queryStationInfo(Long userId, Integer status);

    /**
     * 电站列表
     *
     * @param page
     * @param userId
     * @param type
     * @param order
     * @return
     */
    IPage<Map<String, Object>> queryStation(IPage<PvRelationStation> page, Long userId, Integer type, String order, Integer status);
}
