package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.response.PvStationAlarmResponse;
import com.iesms.openservices.photovoltaic.response.PvStationOpsResponse;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Map;

/**
 * @author Lin yicheng
 * @date 2022/4/27 13:50
 */
public interface PvStationAlarmAndMaintenanceService {

    /**
     * 获取告警数据
     * @param ceCustId
     * @return
     */
    PvStationAlarmResponse getAlarmInfo(Long ceCustId);

    /**
     * 获取运维工单数据
     * @param ceCustId
     * @return
     */
    PvStationOpsResponse getOpsInfo(Long ceCustId);

    /**
     * 获取运行效率
     * @param ceCustId
     * @return
     */
    Map<String, Object> getOperatingEff(Long ceCustId, String orgNo);

    /***
     * @Description 平均数
     * @author duanyingie
     * @data 2022/4/28
     */
    BigDecimal getOrgAVGEqHoursDay(@Param("orgNo") String orgNo);


    /**
     * 获取当前org下的告警信息
     * @param orgNo 部门编号
     * @return
     */
    Integer getCurrentOrgAlarm(@Param("orgNo") String orgNo);
}
