package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.entity.PvStationDevCleanRecordDto;
import com.iesms.openservices.photovoltaic.request.PvStationDevCleanRecordRequest;

import java.util.List;
import java.util.Map;

/**
 * 分布式光伏-->运行维护--清洗记录管理
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-20
 */
public interface PvStationDevCleanRecordService {

    /**
     * 清洗记录管理列表
     */
    List<PvStationDevCleanRecordDto> getPvStationDevCleanRecordList(PvStationDevCleanRecordRequest params);

    /**
     * 清洗记录管理数量
     */
    int getPvStationDevCleanRecordCount(PvStationDevCleanRecordRequest params);

    /**
     * 获取电流曲线信息
     */
    Map<String, Object> getCurrentCurveInfo(PvStationDevCleanRecordRequest params);
}
