package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.common.BaseCrudService;
import com.iesms.openservices.photovoltaic.entity.CeDevice;
import com.iesms.openservices.photovoltaic.request.PvStationDevSchemeSettingRequest;

/**
 * 分布式光伏-->运行维护--智能清洗方案设置
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-20
 */
public interface PvStationDevSchemeSettingService extends BaseCrudService<CeDevice> {

    /**
     * 参数设置
     */
    int controlPanelParamSetting(PvStationDevSchemeSettingRequest params);

    /**
     * 根据设备id查询设置的参数信息
     */
    PvStationDevSchemeSettingRequest getDevSchemeSettingInfo(String deviceId);
}
