package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.entity.PvStationDevSurveyDto;
import com.iesms.openservices.photovoltaic.request.PvStationDevSurveyRequest;

import java.util.List;
import java.util.Map;

/**
 * 分布式光伏-->运行维护--智能清洗设备概况
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-15
 */
public interface PvStationDevSurveyService {

    /**
     * 查询智能设备概况列表
     */
    Map<String, Object> getPvStationDevSurveyList(PvStationDevSurveyRequest params);

    /**
     * 获取机器人详情列表
     */
    List<PvStationDevSurveyDto> getRobotInfoList(PvStationDevSurveyRequest params);

    /**
     * 获取机器人详情列表数量
     */
    int getRobotInfoCount(PvStationDevSurveyRequest params);

    /**
     * 用户名称下拉列表
     */
    List<PvStationDevSurveyDto> getCeCustNameList(PvStationDevSurveyRequest params);

    /**
     * 查询电站机器人左边树信息
     */
    List<PvStationDevSurveyDto> getStationNameList(PvStationDevSurveyRequest params);

    /**
     * @description: 根据用户id 查询 机器人设备信息
     * @author: DuanYingJie
     * @date: 2022/7/11 11:08
     * @param: [ceCustId]
     * @return:
     **/
    List<PvStationDevSurveyDto> getDevNameList(String ceCustId);
}
