package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.entity.PvStationMainDto;
import com.iesms.openservices.photovoltaic.request.PvStationMainRequest;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * 分布式光伏-->首页--政府监管
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-13
 */
public interface PvStationMainService {

    /**
     * 获取首页--基本情况中的信息
     */
    Map<String, Object> getPvStationMainBasicInfo(PvStationMainRequest params);

    /**
     * 获取首页--并网类型和电站类型中的信息
     */
    Map<String, Object> getPvStationMainInfo(PvStationMainRequest params);

    /**
     * 获取首页--屋顶电站占比信息
     */
    Map<String, Object> getRoofStationInfo(PvStationMainRequest params);

    /**
     * 获取首页--十四五指标完成情况信息
     */
    Map<String, Object> getIndexCompleteInfo(PvStationMainRequest params);

    /**
     * 获取地图中--温州市每个区的装机容量排名、数量、装机容量
     */
    List<PvStationMainDto> getRegionalMapInfo(PvStationMainRequest params);

    /**
     * 获取首页--温州市下所有区域计划装机容量和装机容量柱状图
     */
    Map<String, Object> getPlanCapacityHistogram(PvStationMainRequest params);

    /**
     * 获取首页--获取近十二个月的发电量和自发自用电量
     */
    Map<String, Object> getEgenValueList(PvStationMainRequest params) throws ParseException;

    /**
     * 获取首页--电站概况中补贴金额月、年、总累计补贴
     */
    Map<String, Object> getMoneySubsidyTotalInfo(PvStationMainRequest params);

    /**
     * 获取首页--电站概况中月、年、累计补贴金额曲线
     */
    Map<String, Object> getMoneySubsidyTotalCurve(PvStationMainRequest params) throws ParseException;

    /**
     * 获取首页--总发电量和总自发自用电量以及环保贡献里的值
     */
    PvStationMainDto getEgenValueYearSum(PvStationMainRequest params);

    /**
     * 电站健康码信息
     */
    Map<String, Object> getHealthCodeInfo(PvStationMainRequest params);

    /**
     * 获取首页--日平均有效发电小时数
     */
    PvStationMainDto getEqHoursAvg(PvStationMainRequest params);

    /**
     * 获取首页--电站概况环保贡献，累计发电量，累计收益额
     */
    Map<String, Object> getPvStationEnvProInfo(PvStationMainRequest params);
}
