package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.entity.PvStationRefDevInfoDto;
import com.iesms.openservices.photovoltaic.entity.PvStationReferenceUnitSettingDto;
import com.iesms.openservices.photovoltaic.request.PvStationReferenceUnitSettingRequest;

import java.util.List;

/**
 * 分布式光伏-->运行维护--参考单元设置
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-25
 */
public interface PvStationReferenceUnitSettingService {
    /**
     * 获取参考单元设置列表
     */
    List<PvStationReferenceUnitSettingDto> getPvStationDevSchemeSettingList(PvStationReferenceUnitSettingRequest params);

    /**
     * 获取参考单元设置列表数量
     */
    int getPvStationDevSchemeSettingCount(PvStationReferenceUnitSettingRequest params);

    /**
     * 获取设备参考单元信息
     */
    PvStationRefDevInfoDto getPvStationRefDevInfo(PvStationReferenceUnitSettingRequest params);

    /**
     * 新增样本
     */
    int insertPvAiopsSample(PvStationRefDevInfoDto params);

    /**
     * 修改样本
     */
    int updatePvAiopsSample(PvStationRefDevInfoDto params);
}
