package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.request.PvStationReportFormRequest;
import com.iesms.openservices.photovoltaic.response.PvStationReportFormResponse;
import org.apache.ibatis.annotations.Param;

import java.io.OutputStream;
import java.util.List;

/**
 * @author Lin yicheng
 * @date 2022/4/19 15:29
 */
public interface PvStationReportFormService {

    /**
     * 获取通讯故障电站明细
     * @param request
     * @return
     */
    List<PvStationReportFormResponse> getCommFailurePvstatInfo(PvStationReportFormRequest request);

    /**
     * 获取设备故障电站明细
     * @param request
     * @return
     */
    List<PvStationReportFormResponse> getdeviceFailurePvstatInfo(PvStationReportFormRequest request);

    /**
     * 获取0发电量电站明细
     * @param request
     * @return
     */
    List<PvStationReportFormResponse> getZeroEloadPvstatInfo(PvStationReportFormRequest request);

    /**
     * 新增电站明细列表
     */
    List<PvStationReportFormResponse> getPvstatDetailInfo(PvStationReportFormRequest request);

    /**
     * 大有-> 运营管理报表 -> 清单类查询 -> 导出excel和word
     */
    void detailedExport(PvStationReportFormRequest request, OutputStream out);
}
