package com.iesms.openservices.photovoltaic.service;

import cn.hutool.core.lang.Dict;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.iesms.openservices.photovoltaic.entity.PvUav;
import com.iesms.openservices.photovoltaic.request.PvUavQueryRequest;
import com.iesms.openservices.photovoltaic.response.PvUavQueryVo;

import java.util.Collection;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/12/21
 */
public interface PvUavService extends IService<PvUav> {

    /**
     * 无人机档案列表
     *
     * @param request
     * @return
     */
    IPage<PvUavQueryVo> queryList(PvUavQueryRequest request);

    /**
     * 删除
     *
     * @param list
     * @return
     */
    int delete(Collection<?> list);

    /**
     * 查询状态数量
     *
     * @param orgNo
     * @return
     */
    Dict selectPvUavStatusCount(String orgNo);

    /**
     * 查询无人机数量统计
     *
     * @param uavId
     * @param orgNo
     * @return
     */
    Dict selectPvUavCountInfo(Long uavId, String orgNo);
}
