package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.entity.RealtimeWorkingConditionVo;
import com.iesms.openservices.photovoltaic.request.RealtimeWorkingConditionGetRequest;
import com.iesms.openservices.photovoltaic.response.RealtimeWorkingConditionResponse;

import java.util.List;

/**
 * @author Lin yicheng
 * @date 2021/11/30 19:36
 */
public interface RealtimeWorkingConditionService {

    /**
     * 获取储能电站档案信息
     * @param request
     * @return
     */
    RealtimeWorkingConditionResponse querySeStationInfo(RealtimeWorkingConditionGetRequest request);

    /**
     * 获取储能电站下的电池组数量
     * @param request
     * @return
     */
    Long queryBMSTotal(RealtimeWorkingConditionGetRequest request);

    /**
     * 获取储能电站量测点标识
     * @param request
     * @return
     */
    Long querySeStationPoint(RealtimeWorkingConditionGetRequest request);

    /**
     * 获取储能变流器档案信息
     * @param request
     * @return
     */
    RealtimeWorkingConditionResponse queryDevSePcsInfo(RealtimeWorkingConditionGetRequest request);

    /**
     * 获取储能变流器量测点标识
     * @param request
     * @return
     */
    Long queryDevSePcsPoint(RealtimeWorkingConditionGetRequest request);

    /**
     * 获取储能BMS档案信息
     * @param request
     * @return
     */
    RealtimeWorkingConditionResponse queryDevSeBMSInfo(RealtimeWorkingConditionGetRequest request);

    /**
     * 获取储能BMS量测点标识
     * @param request
     * @return
     */
    Long queryDevSeBMSPoint(RealtimeWorkingConditionGetRequest request);

    List<Long> queryPCS(String id);

    List<Long> queryBMS(String id);

}
