package com.iesms.openservices.photovoltaic.service;

import com.iesms.openservices.photovoltaic.entity.*;
import org.apache.ibatis.annotations.Param;

/**
 * @author zhouyi
 * @className RobotConditionService
 * @data 2021/10/22 9:47
 * @Description TODO
 **/
public interface RobotConditionService {

    /***
     * @Description TODO  根据设备id查询机器人的工况状态
     * @author zhouyi
     * @return com.iesms.openservices.photovoltaic.entity.RobotOperatingCondition
     * @data 2021/10/22
     * @param id
     */
    RobotOperatingCondition getRobotByDeviceId(Long id);


    /***
     * @Description TODO  查询机器人轨道长度等属性
     * @author zhouyi
     * @return com.iesms.openservices.photovoltaic.entity.RobotDeviceProperty
     * @data 2021/10/22
     * @param id  机器人设备id
     */
    RobotDeviceProperty getRobotDeviceProperty(Long id);

    /***
     * @Description TODO  更新机器人  启用  停用 状态
     * @author zhouyi
     * @return int
     * @data 2021/10/22
     * @param id  设备id
     * @param runningStatus  运行状态
     */
    int updateRobotStatus(Long id,int runningStatus);
   /***
    * @Description TODO  获取机器人  运行策略的值
    * @author zhouyi
    * @return com.iesms.openservices.photovoltaic.entity.RobotStrategy
    * @data 2021/10/23
    * @param id
    */
    RobotStrategy getRobotStrategy(String id);


    /***
     * @Description TODO 获取机器人电流曲线
     * @author zhouyi
     * @return
     * @data 2021/10/26
     */
    RobotCurrentData getRobotCurrentData(@Param("deviceId") Long deviceId);

    /***
     * @Description TODO
     * @author zhouyi
     * @return 插入  机器人启动记录
     * @data 2021/10/26
     */
    int insertRobotRunHis(RobotRunHis robotRunHis);
}
