/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.photovoltaic.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.iesms.openservices.photovoltaic.common.BaseCrudService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ResolvableType;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public abstract class BaseCrudServiceImpl<M extends BaseMapper<T>, T>
implements BaseCrudService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCrudServiceImpl.class);
    private static final int DEFAULT_BATCH_SIZE = 1000;
    protected Log log = LogFactory.getLog(this.getClass());
    protected Class<T> entityClass = this.currentModelClass();
    protected Class<M> mapperClass = this.currentMapperClass();
    @Autowired
    protected M baseCrudMapper;

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Class<M> getMapperClass() {
        return this.mapperClass;
    }

    @Override
    public boolean save(T entity) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start save >>>>>>");
            LOGGER.debug("entity : " + (entity != null ? entity.toString() : null));
        }
        if (null != entity) {
            return SqlHelper.retBool((Integer)this.baseCrudMapper.insert(entity));
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList) {
        return this.saveBatch(entityList, 1000);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start saveBatch >>>>>>");
            LOGGER.debug("entityList    : " + entityList);
            LOGGER.debug("batchSize     : " + batchSize);
        }
        String sqlStatement = this.getSqlStatement(SqlMethod.INSERT_ONE);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdate(T entity) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start saveOrUpdate >>>>>>");
            LOGGER.debug("entity : " + (entity != null ? entity.toString() : null));
        }
        if (null != entity) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(this.entityClass);
            Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
            String keyProperty = tableInfo.getKeyProperty();
            Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
            Object idVal = ReflectionKit.getFieldValue(entity, (String)tableInfo.getKeyProperty());
            return StringUtils.checkValNull((Object)idVal) || Objects.isNull(this.getById((Serializable)idVal)) ? this.save(entity) : this.updateById(entity);
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdate(T entity, Wrapper<T> updateWrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start saveOrUpdate >>>>>>");
            LOGGER.debug("entity        : " + (entity != null ? entity.toString() : null));
            LOGGER.debug("updateWrapper : " + (updateWrapper != null ? updateWrapper.toString() : null));
        }
        return this.update(entity, updateWrapper) || this.saveOrUpdate(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList) {
        return this.saveOrUpdateBatch(entityList, 1000);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start saveOrUpdateBatch >>>>>>");
            LOGGER.debug("entityList    : " + entityList);
            LOGGER.debug("batchSize     : " + batchSize);
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.entityClass);
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        return SqlHelper.saveOrUpdateBatch(this.entityClass, this.mapperClass, (Log)this.log, entityList, (int)batchSize, (sqlSession, entity) -> {
            Object idVal = ReflectionKit.getFieldValue((Object)entity, (String)keyProperty);
            return StringUtils.checkValNull((Object)idVal) || CollectionUtils.isEmpty((Collection)sqlSession.selectList(this.getSqlStatement(SqlMethod.SELECT_BY_ID), entity));
        }, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(this.getSqlStatement(SqlMethod.UPDATE_BY_ID), (Object)param);
        });
    }

    @Override
    public boolean updateById(T entity) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start updateById >>>>>>");
            LOGGER.debug("entity : " + (entity != null ? entity.toString() : null));
        }
        if (null != entity) {
            return SqlHelper.retBool((Integer)this.baseCrudMapper.updateById(entity));
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList) {
        return this.updateBatchById(entityList, 1000);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start updateBatchById >>>>>>");
            LOGGER.debug("entityList    : " + entityList);
            LOGGER.debug("batchSize     : " + batchSize);
        }
        String sqlStatement = this.getSqlStatement(SqlMethod.UPDATE_BY_ID);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
        });
    }

    @Override
    public boolean update(Wrapper<T> updateWrapper) {
        return this.update(null, updateWrapper);
    }

    @Override
    public boolean update(T entity, Wrapper<T> updateWrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start update >>>>>>");
            LOGGER.debug("entity        : " + (entity != null ? entity.toString() : null));
            LOGGER.debug("updateWrapper : " + (updateWrapper != null ? updateWrapper.toString() : null));
        }
        return SqlHelper.retBool((Integer)this.baseCrudMapper.update(entity, updateWrapper));
    }

    @Override
    public boolean removeById(Serializable id) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start removeById >>>>>>");
            LOGGER.debug("id    : " + id);
        }
        return SqlHelper.retBool((Integer)this.baseCrudMapper.deleteById(id));
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start removeByIds >>>>>>");
            LOGGER.debug("idList    : " + idList);
        }
        if (CollectionUtils.isEmpty(idList)) {
            return false;
        }
        return SqlHelper.retBool((Integer)this.baseCrudMapper.deleteBatchIds(idList));
    }

    @Override
    public boolean remove(Wrapper<T> queryWrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start remove >>>>>>");
            LOGGER.debug("queryWrapper  : " + (queryWrapper != null ? queryWrapper.toString() : null));
        }
        return SqlHelper.retBool((Integer)this.baseCrudMapper.delete(queryWrapper));
    }

    @Override
    public boolean removeByMap(Map<String, Object> columnMap) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start removeByMap >>>>>>");
            LOGGER.debug("columnMap     : " + (columnMap != null ? columnMap.toString() : null));
        }
        Assert.notEmpty(columnMap, (String)"error: columnMap must not be empty", (Object[])new Object[0]);
        return SqlHelper.retBool((Integer)this.baseCrudMapper.deleteByMap(columnMap));
    }

    @Override
    public T getById(Serializable id) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start getById >>>>>>");
            LOGGER.debug("id    : " + id);
        }
        return (T)this.baseCrudMapper.selectById(id);
    }

    @Override
    public T getOne(Wrapper<T> queryWrapper) {
        return this.getOne(queryWrapper, true);
    }

    @Override
    public T getOne(Wrapper<T> queryWrapper, boolean throwEx) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start getOne >>>>>>");
            LOGGER.debug("queryWrapper  : " + (queryWrapper != null ? queryWrapper.toString() : null));
            LOGGER.debug("throwEx       : " + throwEx);
        }
        if (throwEx) {
            return (T)this.baseCrudMapper.selectOne(queryWrapper);
        }
        return (T)SqlHelper.getObject((Log)this.log, (List)this.baseCrudMapper.selectList(queryWrapper));
    }

    @Override
    public Map<String, Object> getMap(Wrapper<T> queryWrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start getMap >>>>>>");
            LOGGER.debug("queryWrapper  : " + (queryWrapper != null ? queryWrapper.toString() : null));
        }
        return (Map)SqlHelper.getObject((Log)this.log, (List)this.baseCrudMapper.selectMaps(queryWrapper));
    }

    @Override
    public <V> V getObj(Wrapper<T> queryWrapper, Function<? super Object, V> mapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start getObj >>>>>>");
            LOGGER.debug("queryWrapper  : " + (queryWrapper != null ? queryWrapper.toString() : null));
            LOGGER.debug("mapper        : " + (mapper != null ? mapper.toString() : null));
        }
        return (V)SqlHelper.getObject((Log)this.log, this.listObjs(queryWrapper, mapper));
    }

    @Override
    public List<T> list(Wrapper<T> queryWrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start list >>>>>>");
            LOGGER.debug("queryWrapper  : " + (queryWrapper != null ? queryWrapper.toString() : null));
        }
        return this.baseCrudMapper.selectList(queryWrapper);
    }

    @Override
    public List<T> listByIds(Collection<? extends Serializable> idList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start listByIds >>>>>>");
            LOGGER.debug("idList  : " + idList);
        }
        return this.baseCrudMapper.selectBatchIds(idList);
    }

    @Override
    public List<T> listByMap(Map<String, Object> columnMap) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start listByMap >>>>>>");
            LOGGER.debug("columnMap  : " + columnMap);
        }
        return this.baseCrudMapper.selectByMap(columnMap);
    }

    @Override
    public List<Map<String, Object>> listMaps(Wrapper<T> queryWrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start listMaps >>>>>>");
            LOGGER.debug("queryWrapper  : " + (queryWrapper != null ? queryWrapper.toString() : null));
        }
        return this.baseCrudMapper.selectMaps(queryWrapper);
    }

    @Override
    public <V> List<V> listObjs(Wrapper<T> queryWrapper, Function<? super Object, V> mapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start listObjs >>>>>>");
            LOGGER.debug("queryWrapper  : " + (queryWrapper != null ? queryWrapper.toString() : null));
            LOGGER.debug("mapper        : " + (mapper != null ? mapper.toString() : null));
        }
        return this.baseCrudMapper.selectObjs(queryWrapper).stream().filter(Objects::nonNull).map(mapper).collect(Collectors.toList());
    }

    @Override
    public <E extends IPage<T>> E page(E page) {
        return this.page(page, (Wrapper<T>)Wrappers.emptyWrapper());
    }

    @Override
    public <E extends IPage<T>> E page(E page, Wrapper<T> queryWrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start page >>>>>>");
            LOGGER.debug("page          : " + (page != null ? page.toString() : null));
            LOGGER.debug("queryWrapper  : " + (queryWrapper != null ? queryWrapper.toString() : null));
        }
        return (E)this.baseCrudMapper.selectPage(page, queryWrapper);
    }

    @Override
    public <E extends IPage<Map<String, Object>>> E pageMaps(E page) {
        return this.pageMaps(page, (Wrapper<T>)Wrappers.emptyWrapper());
    }

    @Override
    public <E extends IPage<Map<String, Object>>> E pageMaps(E page, Wrapper<T> queryWrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start pageMaps >>>>>>");
            LOGGER.debug("page          : " + (page != null ? page.toString() : null));
            LOGGER.debug("queryWrapper  : " + (queryWrapper != null ? queryWrapper.toString() : null));
        }
        return (E)this.baseCrudMapper.selectMapsPage(page, queryWrapper);
    }

    @Override
    public long count(Wrapper<T> queryWrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(">>>>>> start count >>>>>>");
            LOGGER.debug("queryWrapper  : " + (queryWrapper != null ? queryWrapper.toString() : null));
        }
        return (int)SqlHelper.retCount((Long)this.baseCrudMapper.selectCount(queryWrapper));
    }

    protected Class<M> currentMapperClass() {
        return (Class)this.getResolvableType().as(BaseCrudServiceImpl.class).getGeneric(new int[]{0}).getType();
    }

    protected Class<T> currentModelClass() {
        return (Class)this.getResolvableType().as(BaseCrudServiceImpl.class).getGeneric(new int[]{1}).getType();
    }

    protected ResolvableType getResolvableType() {
        return ResolvableType.forClass((Class)ClassUtils.getUserClass(this.getClass()));
    }

    protected String getSqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.getSqlStatement(this.mapperClass, (SqlMethod)sqlMethod);
    }

    protected <E> boolean executeBatch(Collection<E> list, int batchSize, BiConsumer<SqlSession, E> consumer) {
        return SqlHelper.executeBatch(this.entityClass, (Log)this.log, list, (int)batchSize, consumer);
    }

    protected <E> boolean executeBatch(Collection<E> list, BiConsumer<SqlSession, E> consumer) {
        return this.executeBatch(list, 1000, consumer);
    }
}

