package com.iesms.openservices.pvstat.dao;

import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterDayDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterYearDo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface PvStatGenwattmeterDao {
    /***
     * @Author ghl
     * @描述 查询发电电表日数据的用能点集合，并去重，给月和年统计用
     * @Date 2019/10/11 10:02
     * @Param []
     * @return java.util.List<java.lang.Long>
     **/
    List<Long> getPointIdFromGenwattmeterDay();

    /** 根据用能点统计发电电表当月发电量
     * @Author ghl
     * @param pointId :
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatGenwattmeterDayDo>
     * @throws
     * @Date 2019/8/23 17:31
     */
    List<PvStatGenwattmeterDayDo> getMonthPvStatGenwattmeterMonth(@Param("params")Map<String,String> params);

    /** 发电电表年统计查询
     * @Author ghl
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatGenwattmeterMonthDo>
     * @throws
     * @Date 2019/9/4 11:27
     */
    List<PvStatGenwattmeterDayDo> getPvStatGenwattmeterYear(@Param("params")Map<String,String> params);

    /**
     * @Author ghl
     * @描述 更新电表累计数据
     * @Date 2019/11/6 20:34
     * @Param [map]
     * @return int
     **/
    int updateGenwattmeterValueAccum(@Param("params")Map<String,String> map);

    /***
     * @Author ghl
     * @描述 发电电表数据初始化
     * @Date 2019/11/25 14:46
     * @Param [list]
     * @return int
     **/
    int initPvStatGenwattmeterDayDo(@Param("list") List<PvStatGenwattmeterDayDo> list);

    /** 发电电表日发电量插入或更新
     * @Author ghl
     * @param list :
     * @return int
     * @throws
     * @Date 2019/8/23 10:01
     */
    int insertOrUpdatePvStatGenwattmeterDayDo(@Param("list")List<PvStatGenwattmeterDayDo> list);

    /**发电电表月统计插入或更新
     * @Author ghl
     * @param list :
     * @return int
     * @throws
     * @Date 2019/8/23 10:15
     */
    int insertOrUpdatePvStatGenwattmeterMonthDo(@Param("list") List<PvStatGenwattmeterMonthDo> list);

    /**发电电表年发电量插入或更新
     * @Author ghl
     * @param list :
     * @return int
     * @throws
     * @Date 2019/8/23 10:37
     */
    int insertOrUpdatePvStatGenwattmeterYearDo(@Param("list")List<PvStatGenwattmeterYearDo> list);
}
