package com.iesms.openservices.pvstat.dao;

import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterEloadDayDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterEloadMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterEloadYearDo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface PvStatGenwattmeterEloadDao {

    /**
     * @Author ghl
     * @描述 月和年数据查询
     * @Date 2019/10/14 15:57
     * @Param [map]
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatGenwattmeterEloadDayDo>
     **/
    List<PvStatGenwattmeterEloadDayDo> getPvStatGenwattmeterEloadMonthOrYear(@Param("params") Map<String,String> map);


    /**
     * @Author ghl
     * @描述 计量电表发电日统计
     * @Date 2019/10/8 13:59
     * @Param [list] 日数据集合
     * @return int
     **/
    int insertOrUpdatePvStatGenwattmeterEloadDay(@Param("list") List<PvStatGenwattmeterEloadDayDo> list);

    /***
     * @Author ghl
     * @描述 计量电表发电月统计
     * @Date 2019/10/8 16:16
     * @Param [list] 月数据集合
     * @return int
     **/
    int insertOrUpdatePvStatGenwattmeterEloadMonth(@Param("list")List<PvStatGenwattmeterEloadMonthDo> list);

    /***
     * @Author ghl
     * @描述 计量电表发电年统计
     * @Date 2019/10/8 16:22
     * @Param [list] 年数据集合
     * @return int
     **/
    int insertOrUpdatePvStatGenwattmeterEloadYear(@Param("list")List<PvStatGenwattmeterEloadYearDo> list);
}
