package com.iesms.openservices.pvstat.dao;

import com.iesms.openservices.pvstat.entity.PvStatInverterDayDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterYearDo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface PvStatInverterDao {

    /**
     * 根据用能点统计当月逆变器发电量
     *
     * @param poitId :
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatInverterDayDo>
     * @throws
     * @Author ghl
     * @Date 2019/8/23 17:26
     */
    List<PvStatInverterDayDo> getMonthPvStatInverterDayDoByPointId(@Param("pointId") Long pointId);

    /**
     * 查询当前月份所有逆变器数据
     *
     * @return
     */
    List<PvStatInverterDayDo> getMonthPvStatInverterMonth(@Param("params")Map<String, String> map);

    /**
     * @return int
     * @Author ghl
     * @描述 更新逆变器累计收益数据
     * @Date 2019/11/6 20:31
     * @Param [map]
     **/
    int updateInveterValueAccum(@Param("params") Map<String, String> map);

    /***
     * @Author ghl
     * @描述 初始化逆变器数据
     * @Date 2019/11/25 14:53
     * @Param [list]
     * @return int
     **/
    int initPvStatInverterDay(@Param("list") List<PvStatInverterDayDo> list);

    /**
     * 逆变器日发电量插入或更新
     *
     * @param list :
     * @return int
     * @throws
     * @Author ghl
     * @Date 2019/8/22 10:29
     */
    int insertOrUpdatePvStatInverterDay(@Param("list") List<PvStatInverterDayDo> list);

    /**
     * 逆变器月发电量插入或更新
     *
     * @param list :
     * @return int
     * @throws
     * @Author ghl
     * @Date 2019/8/22 10:33
     */
    int insertOrUpdatePvStatInverterMonth(@Param("list") List<PvStatInverterMonthDo> list);

    /**
     * 统计逆变器年发电量数据
     *
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatInverterDayDo>
     * @throws
     * @Author ghl
     * @Date 2019/9/4 10:53
     */
    List<PvStatInverterDayDo> getYearMonthPvStatInverterYear(@Param("params")Map<String, String> map);

    /**
     * 逆变器年发电量插入或更新
     *
     * @param list :
     * @return int
     * @throws
     * @Author ghl
     * @Date 2019/8/23 9:48
     */
    int insertOrUpdatePvStatInverterYear(@Param("list") List<PvStatInverterYearDo> list);
}
