package com.iesms.openservices.pvstat.dao;

import com.iesms.openservices.pvstat.entity.PvStatInverterEloadDayDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterEloadMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterEloadYearDo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/***
 * @Author ghl
 * @描述 逆变器发电功率统计mapper
 * @Date 2019/10/8 16:24
 **/
public interface PvStatInverterEloadDao {
    /**
     * @Author ghl
     * @描述 月和年数据查询
     * @Date 2019/10/14 15:57
     * @Param [map]
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatInverterEloadDayDo>
     **/
     List<PvStatInverterEloadDayDo> getPvStatInverterEloadMonthOrYear(@Param("params")Map<String,String> map);

    /***
     * @Author ghl
     * @描述 逆变器发电功率日统计
     * @Date 2019/10/8 16:38
     * @Param [list]
     * @return int
     **/
    int insertOrUpdatePvStatInverterEloadDay(@Param("list")List<PvStatInverterEloadDayDo> list);

    /***
     * @Author ghl
     * @描述 逆变器发电功率月统计
     * @Date 2019/10/8 16:48
     * @Param [list]
     * @return int
     **/
    int insertOrUpdatePvStatInverterEloadMonth(@Param("list")List<PvStatInverterEloadMonthDo> list);

    /***
     * @Author ghl
     * @描述 逆变器发电功率年统计
     * @Date 2019/10/8 16:48
     * @Param [list]
     * @return int
     **/
    int insertOrUpdatePvStatInverterEloadYear(@Param("list")List<PvStatInverterEloadYearDo> list);

    /**
     * @description:  发电功率日统计曲线（按逆变器）
     * @author: DuanYingJie
     * @date: 2022/10/12 15:28
     * @param: [pvStatInverterEloadDayDo]
     * @return: 发电功率日统计曲线（按逆变器）
     **/
    PvStatInverterEloadDayDo getPvStatInverterEloadDayDo(PvStatInverterEloadDayDo pvStatInverterEloadDayDo);
}
