package com.iesms.openservices.pvstat.dao;

import com.iesms.openservices.pvstat.entity.*;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface PvStatOrgDao {

    /**
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatOrgDayVo>
     * @Author ghl
     * @描述 从电站日数据表查询系统点位日数据
     * @Date 2019/11/9 16:01
     * @Param [map]
     **/
    List<PvStatOrgDayVo> getOrgDayValueFromStation(@Param("params") Map<String, String> map);

    /**
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatPvstationDayDo>
     * @Author ghl
     * @描述
     * @Date 2019/10/18 11:35
     * @Param [map] 封装了：日，月，年的查询标志，后续有其他业务拓展，可将查询条件一并放入map
     **/
    List<PvStatPvstationDayDoVo> getPvStatPvstationDayValue(@Param("params") Map<String, String> map);

    List<PvStatOrgDayDo> getPvStatPvstationMonthAndYear(@Param("params") Map<String, String> map);

    List<PvStatPvstationDayDo> getPvStatPvstationMonthOrYear(@Param("params") Map<String, String> map);

    List<PvStatPvstationDayDo> getPvCapacity(@Param("params") Map<String, String> map);

    /**
     * @return java.math.BigDecimal
     * @Author ghl
     * @描述 查询分公司累计总发电量
     * @Date 2019/11/5 15:40
     * @Param [map]
     **/
    PvStatPvstationDayDo getAllOrgValueAccum(@Param("params") Map<String, String> map);

    /**
     * @return java.math.BigDecimal
     * @Author ghl
     * @描述 查询总公司累计总发电量
     * @Date 2019/11/5 16:02
     * @Param [map]
     **/
    PvStatPvstationDayDo getAllParentOrgValueAccum(@Param("params") Map<String, String> map);

    List<PvStatPvstationDayDo> getPvStatPvstationParentMonthOrYear(@Param("params") Map<String, String> map);

    /**
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatPvstationDayDoVo>
     * @Author ghl
     * @描述 查询总公司数据
     * @Date 2019/10/19 14:10
     * @Param [map]
     **/
    List<PvStatPvstationDayDoVo> getPvStatPvstationParentDayValue(@Param("params") Map<String, String> map);

    List<PvStatOrgMonthDo> getPvStatPvstationMonthValue(@Param("params") Map<String, String> map);

    List<PvStatOrgYearDo> getPvStatPvstationYearValue(@Param("params") Map<String, String> map);

    /***
     * @Author ghl
     * @描述 更新系统单位累积量数据
     * @Date 2019/11/27 15:52
     * @Param [map]
     * @return int
     **/
    int updatePvStatPvstationParentDayAccum(@Param("params") Map<String, String> map);

    int updateMostLevel(@Param("params") Map<String, String> map);

    int updateOrgDayAccum(@Param("params") Map<String, String> map);

    int updateOrgYearValue(@Param("params") Map<String, String> map);

    /***
     * @Author ghl
     * @描述 系统单位发电量日统计
     * @Date 2019/10/8 17:04
     * @Param [list]
     * @return int
     **/
    int insertOrUpdatePvStatOrgDay(@Param("list") List<PvStatOrgDayDo> list);

    /***
     * @Author ghl
     * @描述 系统单位发电量月统计
     * @Date 2019/10/8 17:16
     * @Param [list]
     * @return int
     **/
    int insertOrUpdatePvStatOrgMonth(@Param("list") List<PvStatOrgMonthDo> list);

    /***
     * @Author ghl
     * @描述 系统单位发电量年统计
     * @Date 2019/10/8 17:16
     * @Param [list]
     * @return int
     **/
    int insertOrUpdatePvStatOrgYear(@Param("list") List<PvStatOrgYearDo> list);

    /**
     * 系统单位月年统计查询
     *
     * @param paramMap
     * @return
     */
    List<PvStatOrgMonthDo> getOrgMonthValueFromOrgDay(@Param("params") Map<String, String> paramMap);

    /**
     * 系统单位年统计查询
     *
     * @return
     */
    List<PvStatOrgYearDo> getOrgYearValueFromOrgDay();
}
