package com.iesms.openservices.pvstat.dao;

import com.iesms.openservices.cebase.entity.CeSourceDo;
import com.iesms.openservices.pvstat.entity.*;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface PvStatPvstationDao {

    /**
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatInverterDayDo>
     * @Author ghl
     * @描述 根据逆变器统计电站日发电量
     * @Date 2019/11/10 16:51
     * @Param [map]
     **/
    List<PvStatInverterDayDo> getStationDayValueFromInveter(@Param("params") Map<String, String> map);

    /**
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatGenwattmeterDayDo>
     * @Author ghl
     * @描述 根据发电电表统计电站日发电量
     * @Date 2019/11/10 16:51
     * @Param [map]
     **/
    List<PvStatGenwattmeterDayDo> getStationDayValueFromGenwatt(@Param("params") Map<String, String> map);

    /**
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatPvstationDayDo>
     * @Author ghl
     * @描述 查询初始化光伏电站信息
     * @Date 2019/11/9 18:31
     * @Param []
     **/
    List<PvStatPvstationDayDo> getInitCustMessage();


    /**
     * @return PvStatInverterDayDo ：将参数封装在：pvb_params属性
     * @Author ghl
     * @描述 根据custid查询电站容量
     * @Date 2019/10/16 17:31
     * @Param [map] cusiId：客户id
     **/
    CeSourceDo getCustPropsByCustId(@Param("params") Map<String, Long> map);


    List<PvStatInverterDayDo> getPvstationDayFromInverter(@Param("params") Map<String, String> params);

    List<PvStatGenwattmeterDayDo> getPvstationDayFromGenwattmeter(@Param("params") Map<String, String> params);

    BigDecimal getPvstationEgenValueDayFromInverter(@Param("params") Map<String, String> map);

    BigDecimal getPvstationEgenValueDayFromGenwattmeter(@Param("params") Map<String, String> map);

    /**
     * @return List<PvStatPvstationMonthDo>
     * @Author ghl
     * @描述 电站发电量月，年统计数据查询
     * @Date 2019/10/17 14:45
     * @Param [params]
     **/
    List<PvStatPvstationDayDo> getPvstationFromStationDay(@Param("params") Map<String, String> params);

    /**
     * 根据客户id查询系统单位编号
     *
     * @param ceCustId
     * @return
     */
    String getOrgNoByCustId(String ceCustId);

    /***
     * @Author ghl
     * @描述 更新电站累计量数据
     * @Date 2019/11/27 15:45
     * @Param [map]
     * @return int
     **/
    int updatePvStationDayDo(@Param("params") Map<String, String> map);

    int updatePvStatYearValue(@Param("params") Map<String, String> map);

    /**
     * @return int
     * @Author ghl
     * @描述 插入初始化光伏电站信息
     * @Date 2019/11/9 18:48
     * @Param [list]
     **/
    int insertInitStationOrUpdate(List<PvStatPvstationDayDo> list);

    /**
     * @return int
     * @Author ghl
     * @描述 计算电站累积量
     * @Date 2019/11/7 13:47
     * @Param [map] orgNo 系统单位 dateStat 统计日期
     **/
    int insertOrUpdatePvStatPvstationDayDo(@Param("list") List<PvStatPvstationDayDo> list);

    int insertOrUpdatePvStatPvstationMonthDo(@Param("list") List<PvStatPvstationMonthDo> list);

    int insertOrUpdatePvStatPvstationYearDo(@Param("list") List<PvStatPvstationYearDo> list);

}
