package com.iesms.openservices.pvstat.dao;

import com.iesms.openservices.pvstat.entity.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface PvStatPvstationEloadDao {

    /**
     * @Author ghl
     * @描述 光伏电站日功率统计
     * @Date 2019/11/14 15:12
     * @Param [params]
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatInverterEloadDayDo>
     **/
    List<PvStatInverterEloadDayDo> getPvstationEloadDayFromInverterDay(@Param("params") Map<String,String> params);

    List<PvStatInverterEloadDayDo> getPvstationEloadDayFromInverter(@Param("params") Map<String,String> params);

    List<PvStatGenwattmeterEloadDayDo> getPvstationEloadDayFromGenwattmeter(@Param("params")Map<String,String> params);

    List<PvStatPvstationEloadDayDo> getPvStatPvstationEloadMonthAndYear(@Param("params")Map<String,String> map);
    /**
     * @Author ghl
     * @描述 光伏电站发电功率日统计
     * @Date 2019/10/8 18:01
     * @Param [list]
     * @return int
     **/
    int insertOrUpdatePvStatPvstationEloadDay(@Param("list")List<PvStatPvstationEloadDayDo> list);

    /**
     * @Author ghl
     * @描述 光伏电站发电功率月统计
     * @Date 2019/10/8 18:02
     * @Param [list]
     * @return int
     **/
    int insertOrUpdatePvStatPvstationEloadMonth(@Param("list")List<PvStatPvstationEloadMonthDo> list);

    /**
     * @Author ghl
     * @描述 光伏电站发电功率年统计
     * @Date 2019/10/8 18:03
     * @Param [list]
     * @return int
     **/
    int insertPvStatPvstationEloadYear(@Param("list")List<PvStatPvstationEloadYearDo> list);
}
