package com.iesms.openservices.pvstat.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.pvstat.dao.PvStatGenwattmeterEloadDao;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterEloadDayDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterEloadMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterEloadYearDo;
import com.iesms.openservices.pvstat.service.PvStatGenwattmeterEloadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class PvStatGenwattmeterEloadServiceImpl extends AbstractIesmsBaseService implements PvStatGenwattmeterEloadService {
    private PvStatGenwattmeterEloadDao pvStatGenwattmeterEloadDao;

    @Autowired
    public PvStatGenwattmeterEloadServiceImpl(PvStatGenwattmeterEloadDao pvStatGenwattmeterEloadDao) {
        this.pvStatGenwattmeterEloadDao = pvStatGenwattmeterEloadDao;
    }

    /**
     * @param list
     * @return int
     * @Author ghl
     * @描述 计量电表日统计
     * @Date 2019/10/8 13:59
     * @Param [list] 日数据集合
     */
    @Override
    public int insertOrUpdatePvStatGenwattmeterEloadDay(List<PvStatGenwattmeterEloadDayDo> list) {
        List<PvStatGenwattmeterEloadDayDo> genwattmeterEloadDayDoList = new ArrayList<>();
        if (list.size() > 0) {
            list.forEach(gen -> {
                gen.setId(idGenerator.nextId());
                gen.setDateStat(new Date());
                gen.setGmtCreate(System.currentTimeMillis());
                gen.setGmtModified(System.currentTimeMillis());
                gen.setVersion(1);
                genwattmeterEloadDayDoList.add(gen);
            });
        }

        if (genwattmeterEloadDayDoList.size() > 0) {
            return pvStatGenwattmeterEloadDao.insertOrUpdatePvStatGenwattmeterEloadDay(genwattmeterEloadDayDoList);
        }
        return -1;
    }

    /***
     * @Author ghl
     * @描述 计量电表发电月统计
     * @Date 2019/10/8 16:16
     * @Param [list] 月数据集合
     * @return int
     */
    @Override
    public int insertOrUpdatePvStatGenwattmeterEloadMonth() {
        Map<String, String> map = new HashMap<>();
        map.put("flag", "1");
        List<PvStatGenwattmeterEloadDayDo> genwattmeterEloadMonth = pvStatGenwattmeterEloadDao.getPvStatGenwattmeterEloadMonthOrYear(map);
        if (genwattmeterEloadMonth.size() > 0) {
            List<PvStatGenwattmeterEloadMonthDo> genwattmeterEloadMonthDoList = new ArrayList<>();
            int month = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
            genwattmeterEloadMonth.parallelStream().filter(inv -> inv != null).collect(Collectors.groupingBy(inv2 -> inv2.getCeDeviceId())).forEach((key, genwattmeterList) -> {

                PvStatGenwattmeterEloadMonthDo genwattmeterEloadMonthDo = new PvStatGenwattmeterEloadMonthDo();
                genwattmeterEloadMonthDo.setId(idGenerator.nextId());
                genwattmeterEloadMonthDo.setOrgNo(genwattmeterList.get(0).getOrgNo());
                genwattmeterEloadMonthDo.setCeCustId(genwattmeterList.get(0).getCeCustId());
                genwattmeterEloadMonthDo.setCeDeviceId(genwattmeterList.get(0).getCeDeviceId());
                genwattmeterEloadMonthDo.setCePointId(genwattmeterList.get(0).getCePointId());
                genwattmeterEloadMonthDo.setMonthStat(month);

                int[] maxAndMinIndex = {0, 0};
                String[] dataTime = {null, null};

                // 计算平均值
                BigDecimal totalMonthValue = genwattmeterList.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatGenwattmeterEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalMonthValue != null) {
                    BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(genwattmeterList.size()), 8, BigDecimal.ROUND_UP);
                    genwattmeterEloadMonthDo.setAvgValue(avgValueMonth);
                }
//
//                PvStatGenwattmeterEloadDayDo maxEloadDayDo = genwattmeterList.parallelStream().filter(s -> s.getMaxValue() != null).max((i1, i2) -> i1.getMaxValue().compareTo(i2.getMaxValue())).get();
//
//                PvStatGenwattmeterEloadDayDo minEloadDayDo = genwattmeterList.parallelStream().filter(s -> s.getMinValue() != null).min((i1, i2) -> i1.getMinValue().compareTo(i2.getMinValue())).get();

                BigDecimal[] maxAndMin = {null, null};
                Date[] times = {null, null};
                for (int i = 0; i < genwattmeterList.size(); i++) {
                    maxAndMin[0] = new BigDecimal("0.00000000");
                    maxAndMin[1] = new BigDecimal("0.00000000");
                    if (genwattmeterList.get(i).getMaxValue() != null && genwattmeterList.get(i).getMaxValue().compareTo(maxAndMin[0]) == 1) {
                        maxAndMin[0] = genwattmeterList.get(i).getMaxValue();
                        times[0] = genwattmeterList.get(i).getMaxValueTime();
                    }

                    if (genwattmeterList.get(i).getMinValue() != null && genwattmeterList.get(i).getMinValue().compareTo(maxAndMin[1]) == -1) {
                        maxAndMin[1] = genwattmeterList.get(i).getMinValue();
                        times[1] = genwattmeterList.get(i).getMinValueTime();
                    }
                }

                genwattmeterEloadMonthDo.setMaxValue(maxAndMin[0]);
                genwattmeterEloadMonthDo.setMaxValueTime(times[0]);
                genwattmeterEloadMonthDo.setMinValue(maxAndMin[1]);
                genwattmeterEloadMonthDo.setMinValueTime(times[1]);

                genwattmeterEloadMonthDo.setMeterType(genwattmeterList.get(0).getMeterType());

                genwattmeterEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                genwattmeterEloadMonthDo.setGmtModified(System.currentTimeMillis());
                genwattmeterEloadMonthDo.setVersion(1);

                genwattmeterEloadMonthDoList.add(genwattmeterEloadMonthDo);
            });

            if (genwattmeterEloadMonthDoList.size() > 0) {
                pvStatGenwattmeterEloadDao.insertOrUpdatePvStatGenwattmeterEloadMonth(genwattmeterEloadMonthDoList);
            }
        }
        return 0;
    }

    /***
     * @Author ghl
     * @描述 计量电表发电年统计
     * @Date 2019/10/8 16:22
     * @Param [list] 年数据集合
     * @return int
     */
    @Override
    public int insertOrUpdatePvStatGenwattmeterEloadYear() {
        Map<String, String> map = new HashMap<>();
        map.put("flag", "2");
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        List<PvStatGenwattmeterEloadDayDo> genwattmeterEloadYear = pvStatGenwattmeterEloadDao.getPvStatGenwattmeterEloadMonthOrYear(map);
        if (genwattmeterEloadYear.size() > 0) {
            List<PvStatGenwattmeterEloadYearDo> genwattmeterEloadYearDoList = new ArrayList<>();
            int mear = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
            genwattmeterEloadYear.parallelStream().filter(inv -> inv != null).collect(Collectors.groupingBy(inv2 -> inv2.getCeDeviceId())).forEach((key, genwattmeterList) -> {

                PvStatGenwattmeterEloadYearDo genwattmeterEloadYearDo = new PvStatGenwattmeterEloadYearDo();
                genwattmeterEloadYearDo.setId(idGenerator.nextId());
                genwattmeterEloadYearDo.setOrgNo(genwattmeterList.get(0).getOrgNo());
                genwattmeterEloadYearDo.setCeCustId(genwattmeterList.get(0).getCeCustId());
                genwattmeterEloadYearDo.setCeDeviceId(genwattmeterList.get(0).getCeDeviceId());
                genwattmeterEloadYearDo.setCePointId(genwattmeterList.get(0).getCePointId());
                genwattmeterEloadYearDo.setYearStat(year);

                int[] maxAndMinIndex = {0, 0};
                String[] dataTime = {null, null};

                // 计算平均值
                BigDecimal totalYearValue = genwattmeterList.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatGenwattmeterEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalYearValue != null) {
                    BigDecimal avgValueYear = totalYearValue.divide(BigDecimal.valueOf(genwattmeterList.size()), 8, BigDecimal.ROUND_UP);
                    genwattmeterEloadYearDo.setAvgValue(avgValueYear);
                }
//
//                PvStatGenwattmeterEloadDayDo maxEloadDayDo = genwattmeterList.parallelStream().filter(s -> s.getMaxValue() != null).max((i1, i2) -> i1.getMaxValue().compareTo(i2.getMaxValue())).get();
//
//                PvStatGenwattmeterEloadDayDo minEloadDayDo = genwattmeterList.parallelStream().filter(s -> s.getMinValue() != null).min((i1, i2) -> i1.getMinValue().compareTo(i2.getMinValue())).get();

                BigDecimal[] maxAndMin = {null, null};
                Date[] times = {null, null};
                for (int i = 0; i < genwattmeterList.size(); i++) {
                    maxAndMin[0] = new BigDecimal("0.00000000");
                    maxAndMin[1] = new BigDecimal("0.00000000");
                    if (genwattmeterList.get(i).getMaxValue() != null && genwattmeterList.get(i).getMaxValue().compareTo(maxAndMin[0]) == 1) {
                        maxAndMin[0] = genwattmeterList.get(i).getMaxValue();
                        times[0] = genwattmeterList.get(i).getMaxValueTime();
                    }

                    if (genwattmeterList.get(i).getMinValue() != null && genwattmeterList.get(i).getMinValue().compareTo(maxAndMin[1]) == -1) {
                        maxAndMin[1] = genwattmeterList.get(i).getMinValue();
                        times[1] = genwattmeterList.get(i).getMinValueTime();
                    }
                }
                genwattmeterEloadYearDo.setMaxValue(maxAndMin[0]);
                genwattmeterEloadYearDo.setMaxValueTime(times[0]);
                genwattmeterEloadYearDo.setMinValue(maxAndMin[1]);
                genwattmeterEloadYearDo.setMinValueTime(times[1]);

                genwattmeterEloadYearDo.setMeterType(genwattmeterList.get(0).getMeterType());

                genwattmeterEloadYearDo.setGmtCreate(System.currentTimeMillis());
                genwattmeterEloadYearDo.setGmtModified(System.currentTimeMillis());
                genwattmeterEloadYearDo.setVersion(1);

                genwattmeterEloadYearDoList.add(genwattmeterEloadYearDo);
            });

            if (genwattmeterEloadYearDoList.size() > 0) {
                pvStatGenwattmeterEloadDao.insertOrUpdatePvStatGenwattmeterEloadYear(genwattmeterEloadYearDoList);
            }
        }
        return 0;
    }
}
