package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cebase.util.CommonUtils;
import com.iesms.openservices.pvstat.dao.PvStatGenwattmeterDao;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterDayDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterYearDo;
import com.iesms.openservices.pvstat.service.PvStatGenwattmeterService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class PvStatGenwattmeterServiceImpl extends AbstractIesmsBaseService implements PvStatGenwattmeterService {

    Logger logger = LoggerFactory.getLogger(getClass());

    private PvStatGenwattmeterDao pvStatGenwattmeterDao;

    @Autowired
    public PvStatGenwattmeterServiceImpl(PvStatGenwattmeterDao pvStatGenwattmeterDao) {
        this.pvStatGenwattmeterDao = pvStatGenwattmeterDao;
    }

    /**
     * @param map
     * @return int
     * @Author ghl
     * @描述 更新电表累计数据
     * @Date 2019/11/6 20:34
     * @Param [map]
     */
    @Override
    public int updateGenwattmeterValueAccum(Map<String, String> map) {
        return pvStatGenwattmeterDao.updateGenwattmeterValueAccum(map);
    }

    /***
     * @Author ghl
     * @描述 发电电表数据初始化
     * @Date 2019/11/25 14:46
     * @Param [list]
     * @return int
     *
     * @param list*/
    @Override
    public int initPvStatGenwattmeterDayDo(List<PvStatGenwattmeterDayDo> list) {
        List<PvStatGenwattmeterDayDo> pvStatGenwattmeterDayDoList = new ArrayList<>();
        if (list == null) {
            return -1;
        }
        // 删除为空的对象
        list.removeIf(Objects::isNull);

        if (list.size() < 1) {
            return -1;
        }
        for (PvStatGenwattmeterDayDo initPvStatGenwattmeterDayDo : list) {
            initPvStatGenwattmeterDayDo.setId(idGenerator.nextId());
            initPvStatGenwattmeterDayDo.setGmtCreate(System.currentTimeMillis());
            initPvStatGenwattmeterDayDo.setGmtModified(System.currentTimeMillis());
            initPvStatGenwattmeterDayDo.setVersion(1);
            pvStatGenwattmeterDayDoList.add(initPvStatGenwattmeterDayDo);
        }

        return pvStatGenwattmeterDao.initPvStatGenwattmeterDayDo(pvStatGenwattmeterDayDoList);
    }

    /**
     * 发电电表日发电量插入或更新
     *
     * @param list :
     * @return int
     * @throws
     * @Author ghl
     * @Date 2019/8/23 10:01
     */
    @Override
    public int insertOrUpdatePvStatGenwattmeterDayDo(List<PvStatGenwattmeterDayDo> list) {
        List<PvStatGenwattmeterDayDo> genwattmeterDayDoList = new ArrayList<>();
        if (list.size() > 0) {
            for (PvStatGenwattmeterDayDo gen : list) {
                try {
                    gen.setId(idGenerator.nextId());
                    gen.setVersion(1);
                    gen.setGmtCreate(System.currentTimeMillis());
                    gen.setGmtModified(System.currentTimeMillis());
                    genwattmeterDayDoList.add(gen);
                } catch (Exception e) {
                    logger.error("insertOrUpdatePvStatGenwattmeterDayDo error:" + e.getMessage(), e.fillInStackTrace());
                    logger.error(gen.toString());
                }
            }

        }
        return pvStatGenwattmeterDao.insertOrUpdatePvStatGenwattmeterDayDo(genwattmeterDayDoList);
    }

    /**
     * 发电电表月统计插入或更新
     *
     * @return int
     * @throws
     * @Author ghl
     * @Date 2019/8/23 10:15
     */
    @Override
    public int insertOrUpdatePvStatGenwattmeterMonthDo() {

        Map<String, String> params = CommonUtils.getFirstDayAndLastDayOfMonth();
        /**
         * 版本修改思路：
         * 由于考虑到按年统计也是从日统计表获取，如果逆变器数量很多，之前的方式存在问题，
         * 且月收入明细需要通过复杂计算，sql实现不了，所以将原来的业务逻辑进行重写
         **/
        List<PvStatGenwattmeterMonthDo> monthDoList = new ArrayList<>();
        // 通过用能点查询用能点当前月份的所有数据
        //    params.put("pointId", String.valueOf(pointId));
        List<PvStatGenwattmeterDayDo> pvGenwattmeterMonthDoList = pvStatGenwattmeterDao.getMonthPvStatGenwattmeterMonth(params);
        if (pvGenwattmeterMonthDoList.size() > 0) {
            pvGenwattmeterMonthDoList.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(PvStatGenwattmeterDayDo::getCeCustId)).forEach((k, genwattmeterMonthDoList) -> {
                PvStatGenwattmeterMonthDo monthDo = new PvStatGenwattmeterMonthDo();
                // 月总发电量
                BigDecimal egenValueMonth = null;
                // 月总收益
                BigDecimal pvProfitTotalMonth = null;
                // 月节标准煤量
                BigDecimal sscqValueMonth = new BigDecimal("0.00000000");
                // 月减二氧化碳排放量
                BigDecimal scdeValueMonth = new BigDecimal("0.00000000");
                // 月减二氧化硫排放量
                BigDecimal ssdeValueMonth = new BigDecimal("0.00000000");
                // 月减森林砍伐面积
                BigDecimal sdaValueMonth = new BigDecimal("0.00000000");
                if (genwattmeterMonthDoList.size() > 0) {
                    // 月总发电量
                    egenValueMonth = genwattmeterMonthDoList.parallelStream().filter(s -> s.getEgenValueDay() != null).map(PvStatGenwattmeterDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    //月收益总额
                    pvProfitTotalMonth = genwattmeterMonthDoList.parallelStream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatGenwattmeterDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sscqValueMonthTotal = genwattmeterMonthDoList.parallelStream().filter(s -> s.getSscqValueDay() != null).map(PvStatGenwattmeterDayDo::getSscqValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    sscqValueMonth = sscqValueMonth.add(sscqValueMonthTotal);
                    BigDecimal scdeValueMonthTotal = genwattmeterMonthDoList.parallelStream().filter(s -> s.getScdeValueDay() != null).map(PvStatGenwattmeterDayDo::getScdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    scdeValueMonth = scdeValueMonth.add(scdeValueMonthTotal);
                    BigDecimal ssdeValueMonthTotal = genwattmeterMonthDoList.parallelStream().filter(s -> s.getSsdeValueDay() != null).map(PvStatGenwattmeterDayDo::getSsdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    ssdeValueMonth = ssdeValueMonth.add(ssdeValueMonthTotal);
                    BigDecimal sdaValueMonthTotal = genwattmeterMonthDoList.parallelStream().filter(s -> s.getSdaValueDay() != null).map(PvStatGenwattmeterDayDo::getSdaValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    sdaValueMonth = sdaValueMonth.add(sdaValueMonthTotal);

                    if (genwattmeterMonthDoList.size() == 1) {
                        monthDo.setEndEgenValueMonth(genwattmeterMonthDoList.get(0).getEndEgenValueDay());
                    } else {
                        monthDo.setEndEgenValueMonth(genwattmeterMonthDoList.get(genwattmeterMonthDoList.size() - 1).getEndEgenValueDay());
                    }

                    // 计算月收益明细
                    String pvProfitDetailMonth = null;
                    List<String> pvProfitDetailList = genwattmeterMonthDoList.parallelStream().filter(s -> s.getPvProfitDetailDay() != null).map(PvStatGenwattmeterDayDo::getPvProfitDetailDay).collect(Collectors.toList());
                    // 因为是同一个用能点的数据 ，所以type，pvbParams都相同
                    if (pvProfitDetailList.size() > 0) {
                        pvProfitDetailMonth = PvstatUtil.getpvProfitDetail2(pvProfitDetailList);
                    }

                    monthDo.setId(idGenerator.nextId());
                    monthDo.setOrgNo(genwattmeterMonthDoList.get(0).getOrgNo());
                    monthDo.setCeCustId(genwattmeterMonthDoList.get(0).getCeCustId());
                    monthDo.setCeDeviceId(genwattmeterMonthDoList.get(0).getCeDeviceId());
                    monthDo.setMeterType(genwattmeterMonthDoList.get(0).getMeterType());
                    monthDo.setCePointId(genwattmeterMonthDoList.get(0).getCePointId());
                    monthDo.setMonthStat(Integer.parseInt(DateConvertUtils.convertToString(new Date(), "yyyyMM")));
                    monthDo.setEgenValueMonth(egenValueMonth);
                    monthDo.setStartEgenValueMonth(genwattmeterMonthDoList.get(0).getStartEgenValueDay());
                    monthDo.setTmplPvBillingId(genwattmeterMonthDoList.get(0).getTmplPvBillingId());
                    monthDo.setPvbType(genwattmeterMonthDoList.get(0).getPvbType());
                    monthDo.setPvbParams(genwattmeterMonthDoList.get(0).getPvbParams());
                    monthDo.setPvProfitTotalMonth(pvProfitTotalMonth);
                    monthDo.setSscqValueMonth(sscqValueMonth);
                    monthDo.setScdeValueMonth(scdeValueMonth);
                    monthDo.setSsdeValueMonth(ssdeValueMonth);
                    monthDo.setSdaValueMonth(sdaValueMonth);
                    monthDo.setGmtCreate(System.currentTimeMillis());
                    monthDo.setGmtModified(System.currentTimeMillis());
                    monthDo.setVersion(1);
                    // 发电电表收益明细
                    monthDo.setPvProfitDetailMonth(pvProfitDetailMonth);
                    monthDoList.add(monthDo);
                }
            });
        }

        if (monthDoList.size() > 0) {
            pvStatGenwattmeterDao.insertOrUpdatePvStatGenwattmeterMonthDo(monthDoList);
        }
        return -1;
    }

    /**
     * 发电电表年发电量插入或更新
     *
     * @return int
     * @throws
     * @Author ghl
     * @Date 2019/8/23 10:37
     */
    @Override
    public int insertOrUpdatePvStatGenwattmeterYearDo() {

        List<PvStatGenwattmeterYearDo> yearDoList = new ArrayList<>();
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        // 通过用能点查询用能点n年数据
        Map<String, String> params = new HashMap<>();
        String startDate = getFirstDayMonthOfYear();
        params.put("startDate", startDate);
//                params.put("pointId", String.valueOf(pointId));
        List<PvStatGenwattmeterDayDo> pvGenwattmeterYearDoList = pvStatGenwattmeterDao.getPvStatGenwattmeterYear(params);
        if (pvGenwattmeterYearDoList.size() > 0) {
            pvGenwattmeterYearDoList.parallelStream().filter(s -> s.getCeCustId() != null).collect(Collectors.groupingBy(s -> s.getCeCustId())).forEach((key, genwattmeterYearDoList) -> {
                PvStatGenwattmeterYearDo yearDo = new PvStatGenwattmeterYearDo();
                // 年总发电量
                BigDecimal egenValueYear = null;
                // 年总收益
                BigDecimal pvProfitTotalYear = null;
                // 年节标准煤量
                BigDecimal sscqValueYear = new BigDecimal("0.00000000");
                // 年减二氧化碳排放量
                BigDecimal scdeValueYear = new BigDecimal("0.00000000");
                // 年减二氧化硫排放量
                BigDecimal ssdeValueYear = new BigDecimal("0.00000000");
                // 年减森林砍伐面积
                BigDecimal sdaValueYear = new BigDecimal("0.00000000");

                // 年总发电量
                egenValueYear = genwattmeterYearDoList.parallelStream().filter(s -> s.getEgenValueDay() != null).map(PvStatGenwattmeterDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                pvProfitTotalYear = genwattmeterYearDoList.parallelStream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatGenwattmeterDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sscqValueYearTotal = genwattmeterYearDoList.parallelStream().filter(s -> s.getSscqValueDay() != null).map(PvStatGenwattmeterDayDo::getSscqValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                sscqValueYear = sscqValueYear.add(sscqValueYearTotal);
                BigDecimal scdeValueYearTotal = genwattmeterYearDoList.parallelStream().filter(s -> s.getScdeValueDay() != null).map(PvStatGenwattmeterDayDo::getScdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                scdeValueYear = scdeValueYear.add(scdeValueYearTotal);
                BigDecimal ssdeValueYearTotal = genwattmeterYearDoList.parallelStream().filter(s -> s.getSsdeValueDay() != null).map(PvStatGenwattmeterDayDo::getSsdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                ssdeValueYear = ssdeValueYear.add(ssdeValueYearTotal);
                BigDecimal sdaValueYearTotal = genwattmeterYearDoList.parallelStream().filter(s -> s.getSdaValueDay() != null).map(PvStatGenwattmeterDayDo::getSdaValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                sdaValueYear = sdaValueYear.add(sdaValueYearTotal);

                if (genwattmeterYearDoList.size() == 1) {
                    yearDo.setEndEgenValueYear(genwattmeterYearDoList.get(0).getEndEgenValueDay());
                } else {
                    yearDo.setEndEgenValueYear(genwattmeterYearDoList.get(genwattmeterYearDoList.size() - 1).getEndEgenValueDay());
                }

                // 计算年收益明细
                String pvProfitDetailYear = null;
                List<String> pvProfitDetailList = genwattmeterYearDoList.parallelStream().filter(s -> s.getPvProfitDetailDay() != null).map(PvStatGenwattmeterDayDo::getPvProfitDetailDay).collect(Collectors.toList());
                if (pvProfitDetailList.size() > 0) {
                    pvProfitDetailYear = PvstatUtil.getpvProfitDetail2(pvProfitDetailList);
                }

                yearDo.setId(idGenerator.nextId());
                yearDo.setOrgNo(genwattmeterYearDoList.get(0).getOrgNo());
                yearDo.setCeCustId(genwattmeterYearDoList.get(0).getCeCustId());
                yearDo.setCePointId(genwattmeterYearDoList.get(0).getCePointId());
                yearDo.setCeDeviceId(genwattmeterYearDoList.get(0).getCeDeviceId());
                yearDo.setMeterType(genwattmeterYearDoList.get(0).getMeterType());
                //       yearDo.setCePointId(pointId);
                yearDo.setYearStat(year);
                yearDo.setEgenValueYear(egenValueYear);
                yearDo.setStartEgenValueYear(genwattmeterYearDoList.get(0).getStartEgenValueDay());
                yearDo.setTmplPvBillingId(genwattmeterYearDoList.get(0).getTmplPvBillingId());
                yearDo.setPvbType(genwattmeterYearDoList.get(0).getPvbType());
                yearDo.setPvbParams(genwattmeterYearDoList.get(0).getPvbParams());
                yearDo.setPvProfitTotalYear(pvProfitTotalYear);
                yearDo.setSscqValueYear(sscqValueYear);
                yearDo.setScdeValueYear(scdeValueYear);
                yearDo.setSsdeValueYear(ssdeValueYear);
                yearDo.setSdaValueYear(sdaValueYear);
                yearDo.setGmtCreate(System.currentTimeMillis());
                yearDo.setGmtModified(System.currentTimeMillis());
                yearDo.setVersion(1);
                // 发电电表收益明细
                yearDo.setPvProfitDetailYear(pvProfitDetailYear);
                yearDoList.add(yearDo);
            });
        }
        if (yearDoList.size() > 0) {
            return pvStatGenwattmeterDao.insertOrUpdatePvStatGenwattmeterYearDo(yearDoList);
        }
        return -1;
    }


    /**
     * 获取每年一月，格式：201901
     *
     * @return
     */
    public String getFirstDayMonthOfYear() {
        Calendar cale = Calendar.getInstance();
        int year = cale.get(Calendar.YEAR);
        String startDay = year + "0101";
        return startDay;
    }
}
