package com.iesms.openservices.pvstat.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.base.util.CurveUtil;
import com.iesms.openservices.pvstat.dao.PvStatInverterEloadDao;
import com.iesms.openservices.pvstat.entity.PvStatInverterEloadDayDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterEloadMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterEloadYearDo;
import com.iesms.openservices.pvstat.service.PvStatInverterEloadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class PvStatInverterEloadServiceImpl extends AbstractIesmsBaseService implements PvStatInverterEloadService {

    private PvStatInverterEloadDao pvStatInverterEloadDao;

    @Autowired
    public PvStatInverterEloadServiceImpl(PvStatInverterEloadDao pvStatInverterEloadDao) {
        this.pvStatInverterEloadDao = pvStatInverterEloadDao;
    }

    /**
     * @param map
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatInverterEloadDayDo>
     * @Author ghl
     * @描述 月和年数据查询
     * @Date 2019/10/14 15:57
     * @Param [map]
     */
    @Override
    public List<PvStatInverterEloadDayDo> getPvStatInverterEloadMonthOrYear(Map<String, String> map) {
        return null;
    }

    /***
     * @Author ghl
     * @描述 逆变器发电功率日统计
     * @Date 2019/10/8 16:38
     * @Param [list]
     * @return int
     *
     * @param list*/
    @Override
    public int insertOrUpdatePvStatInverterEloadDay(List<PvStatInverterEloadDayDo> list) {
        List<PvStatInverterEloadDayDo> inverterEloadDayDoList = new ArrayList<>();
        if (list.size() > 0) {
            list.stream().filter(s -> s != null).forEach(inverter -> {
                inverter.setId(idGenerator.nextId());
                inverter.setGmtCreate(System.currentTimeMillis());
                inverter.setGmtModified(System.currentTimeMillis());
                inverter.setVersion(1);
                inverterEloadDayDoList.add(inverter);
            });
        }

        if (inverterEloadDayDoList.size() > 0) {
            return pvStatInverterEloadDao.insertOrUpdatePvStatInverterEloadDay(inverterEloadDayDoList);
        }

        return -1;
    }

    /***
     * @Author ghl
     * @描述 逆变器发电功率月统计
     * @Date 2019/10/8 16:48
     * @Param [list]
     * @return int
     **/
    @Override
    public int insertOrUpdatePvStatInverterEloadMonth() {
        //flag
        Map<String, String> map = new HashMap<>();
        map.put("flag", "1");
        List<PvStatInverterEloadDayDo> inverterEloadMonth = pvStatInverterEloadDao.getPvStatInverterEloadMonthOrYear(map);
        if (inverterEloadMonth.size() > 0) {
            List<PvStatInverterEloadMonthDo> inverterEloadMonthDoList = new ArrayList<>();
            int month = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
            inverterEloadMonth.parallelStream().filter(inv -> inv != null).collect(Collectors.groupingBy(inv2 -> inv2.getCePointId())).forEach((key, inverterList) -> {

                PvStatInverterEloadMonthDo inverterEloadMonthDo = new PvStatInverterEloadMonthDo();
                inverterEloadMonthDo.setId(idGenerator.nextId());
                inverterEloadMonthDo.setOrgNo(inverterList.get(0).getOrgNo());
                inverterEloadMonthDo.setCeCustId(inverterList.get(0).getCeCustId());
                inverterEloadMonthDo.setCeDeviceId(inverterList.get(0).getCeDeviceId());
                inverterEloadMonthDo.setCePointId(inverterList.get(0).getCePointId());
                inverterEloadMonthDo.setMonthStat(month);

                int[] maxAndMinIndex = {0, 0};
                String[] dataTime = {null, null};

                // 计算平均值
                BigDecimal totalMonthValue = inverterList.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatInverterEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalMonthValue != null) {
                    BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(inverterList.size()), 8, BigDecimal.ROUND_UP);
                    inverterEloadMonthDo.setAvgValue(avgValueMonth);
                }

//                PvStatInverterEloadDayDo maxEloadDayDo = inverterList.parallelStream().filter(s -> s.getMaxValue() != null).max((i1, i2) -> i1.getMaxValue().compareTo(i2.getMaxValue())).get();
//
//                PvStatInverterEloadDayDo minEloadDayDo = inverterList.parallelStream().filter(s -> s.getMinValue() != null).min((i1, i2) -> i1.getMinValue().compareTo(i2.getMinValue())).get();
                BigDecimal[] maxAndMin = {null, null};
                Date[] times = {null, null};
                for (int i = 0; i < inverterList.size(); i++) {
                    maxAndMin[0] = new BigDecimal("0.00000000");
                    maxAndMin[1] = new BigDecimal("0.00000000");
                    if (inverterList.get(i).getMaxValue() != null && inverterList.get(i).getMaxValue().compareTo(maxAndMin[0]) == 1) {
                        maxAndMin[0] = inverterList.get(i).getMaxValue();
                        times[0] = inverterList.get(i).getMaxValueTime();
                    }

                    if (inverterList.get(i).getMinValue() != null && inverterList.get(i).getMinValue().compareTo(maxAndMin[1]) == -1) {
                        maxAndMin[1] = inverterList.get(i).getMinValue();
                        times[1] = inverterList.get(i).getMinValueTime();
                    }
                }

                inverterEloadMonthDo.setMaxValue(maxAndMin[0]);
                inverterEloadMonthDo.setMaxValueTime(times[0]);
                inverterEloadMonthDo.setMinValue(maxAndMin[1]);
                inverterEloadMonthDo.setMinValueTime(times[1]);

                inverterEloadMonthDo.setInverterCapacity(inverterList.get(0).getInverterCapacity());

                inverterEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                inverterEloadMonthDo.setGmtModified(System.currentTimeMillis());
                inverterEloadMonthDo.setVersion(1);

                inverterEloadMonthDoList.add(inverterEloadMonthDo);
            });

            if (inverterEloadMonthDoList.size() > 0) {
                pvStatInverterEloadDao.insertOrUpdatePvStatInverterEloadMonth(inverterEloadMonthDoList);
            }
        }
        return -1;
    }

    /***
     * @Author ghl
     * @描述 逆变器发电功率年统计
     * @Date 2019/10/8 16:48
     * @Param [list]
     * @return int
     **/
    @Override
    public int insertOrUpdatePvStatInverterEloadYear() {
//flag
        Map<String, String> map = new HashMap<>();
        map.put("flag", "2");
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        List<PvStatInverterEloadDayDo> inverterEloadYear = pvStatInverterEloadDao.getPvStatInverterEloadMonthOrYear(map);
        if (inverterEloadYear.size() > 0) {
            List<PvStatInverterEloadYearDo> inverterEloadYearDoList = new ArrayList<>();
            int mear = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
            inverterEloadYear.parallelStream().filter(inv -> inv != null).collect(Collectors.groupingBy(inv2 -> inv2.getCePointId())).forEach((key, inverterList) -> {

                PvStatInverterEloadYearDo inverterEloadYearDo = new PvStatInverterEloadYearDo();
                inverterEloadYearDo.setId(idGenerator.nextId());
                inverterEloadYearDo.setOrgNo(inverterList.get(0).getOrgNo());
                inverterEloadYearDo.setCeCustId(inverterList.get(0).getCeCustId());
                inverterEloadYearDo.setCeDeviceId(inverterList.get(0).getCeDeviceId());
                inverterEloadYearDo.setCePointId(inverterList.get(0).getCePointId());
                inverterEloadYearDo.setYearStat(year);

                int[] maxAndMinIndex = {0, 0};
                String[] dataTime = {null, null};

                // 计算平均值
                BigDecimal totalYearValue = inverterList.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatInverterEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalYearValue != null && inverterList.size() > 0) {
                    BigDecimal avgValueYear = totalYearValue.divide(BigDecimal.valueOf(inverterList.size()), 8, BigDecimal.ROUND_UP);
                    inverterEloadYearDo.setAvgValue(avgValueYear);
                }

//                PvStatInverterEloadDayDo maxEloadDayDo = inverterList.parallelStream().filter(s -> s.getMaxValue() != null).max((i1, i2) -> i1.getMaxValue().compareTo(i2.getMaxValue())).get();
//
//                PvStatInverterEloadDayDo minEloadDayDo = inverterList.parallelStream().filter(s -> s.getMinValue() != null).min((i1, i2) -> i1.getMinValue().compareTo(i2.getMinValue())).get();

                BigDecimal[] maxAndMin = {null, null};
                Date[] times = {null, null};
                for (int i = 0; i < inverterList.size(); i++) {
                    maxAndMin[0] = new BigDecimal("0.00000000");
                    maxAndMin[1] = new BigDecimal("0.00000000");
                    if (inverterList.get(i).getMaxValue() != null && inverterList.get(i).getMaxValue().compareTo(maxAndMin[0]) == 1) {
                        maxAndMin[0] = inverterList.get(i).getMaxValue();
                        times[0] = inverterList.get(i).getMaxValueTime();
                    }

                    if (inverterList.get(i).getMinValue() != null && inverterList.get(i).getMinValue().compareTo(maxAndMin[1]) == -1) {
                        maxAndMin[1] = inverterList.get(i).getMinValue();
                        times[1] = inverterList.get(i).getMinValueTime();
                    }
                }

                inverterEloadYearDo.setMaxValue(maxAndMin[0]);
                inverterEloadYearDo.setMaxValueTime(times[0]);
                inverterEloadYearDo.setMinValue(maxAndMin[1]);
                inverterEloadYearDo.setMinValueTime(times[1]);

                inverterEloadYearDo.setInverterCapacity(inverterList.get(0).getInverterCapacity());

                inverterEloadYearDo.setGmtCreate(System.currentTimeMillis());
                inverterEloadYearDo.setGmtModified(System.currentTimeMillis());
                inverterEloadYearDo.setVersion(1);

                inverterEloadYearDoList.add(inverterEloadYearDo);
            });

            if (inverterEloadYearDoList.size() > 0) {
                pvStatInverterEloadDao.insertOrUpdatePvStatInverterEloadYear(inverterEloadYearDoList);
            }
        }
        return -1;
    }

    @Override
    public Map<String, Object> getPvStatInverterEloadDayDo(PvStatInverterEloadDayDo pvStatInverterEloadDayDo) {
        Map<String, Object> returnMap = new HashMap<>();
        pvStatInverterEloadDayDo.setNewDate(LocalDate.now().toString());
        PvStatInverterEloadDayDo pvStatInverterEloadDayDo1 = pvStatInverterEloadDao.getPvStatInverterEloadDayDo(pvStatInverterEloadDayDo);
        List<String> eloadValue = CurveUtil.getValues(pvStatInverterEloadDayDo1, "eloadValue", 2, 97);
        String[] labels = CurveUtil.getDayLables(96, 15);
        returnMap.put("value", eloadValue);
        returnMap.put("labels", labels);
        return returnMap;
    }
}
